/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.forge;

import com.stereowalker.unionlib.api.creativetabs.CreativeTabBuilder;
import com.stereowalker.unionlib.core.registries.RegistryHolder;
import com.stereowalker.unionlib.core.registries.RegistryObject;
import com.stereowalker.unionlib.insert.ClientInserts;
import com.stereowalker.unionlib.insert.Inserts;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import java.lang.reflect.Field;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class PlatformHelper {
    public static boolean isClientInstance() {
        return FMLEnvironment.dist.isClient();
    }

    public static boolean isServerInstance() {
        return FMLEnvironment.dist.isDedicatedServer();
    }

    public static boolean isDevEnvironment() {
        return !FMLEnvironment.production;
    }

    public static <T extends BasePacket> void registerMessage(SimpleChannel channel, int index, Class<T> messageType, Function<FriendlyByteBuf, T> decoder) {
        channel.registerMessage(index, messageType, BasePacket::encode, decoder, (packet, context) -> packet.message((Supplier<NetworkEvent.Context>)context));
    }

    public static void handleEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(ModHandler::registerAllServerRelaodableResources);
        forgeBus.addListener(event -> {
            if (ModHandler.getLoadState().runsOnServer()) {
                boolean weCrit = false;
                double critRate = event.getEntity().m_21133_(UAttributes.CRITICAL_RATE);
                if (critRate > 0.0 && !event.isVanillaCritical()) {
                    Random random = new Random();
                    if (random.nextDouble() < critRate) {
                        weCrit = true;
                        event.setResult(Event.Result.ALLOW);
                    }
                }
                if (event.isVanillaCritical() || weCrit) {
                    event.setDamageModifier((float)event.getEntity().m_21133_(UAttributes.CRITICAL_DAMAGE));
                }
            }
        });
        forgeBus.addListener(evt -> Inserts.PLAYER_ATTACK.insert(evt.getEntity(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }));
        forgeBus.addListener(evt -> Inserts.ANVIL_CONTENT_CHANGE.insert(evt.getLeft(), evt.getRight(), evt.getName(), evt.getPlayer(), evt.getOutput(), arg_0 -> ((AnvilUpdateEvent)evt).setOutput(arg_0), evt.getCost(), arg_0 -> ((AnvilUpdateEvent)evt).setCost(arg_0), evt.getMaterialCost(), arg_0 -> ((AnvilUpdateEvent)evt).setMaterialCost(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(evt -> Inserts.LIVING_FALL.insert(evt.getEntity(), evt.getDistance(), arg_0 -> ((LivingFallEvent)evt).setDistance(arg_0), evt.getDamageMultiplier(), arg_0 -> ((LivingFallEvent)evt).setDamageMultiplier(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(evt -> Inserts.FOV.insert(evt.getPlayer(), evt.getFovModifier(), evt.getNewFovModifier(), arg_0 -> ((ComputeFovModifierEvent)evt).setNewFovModifier(arg_0)));
        forgeBus.addListener(event -> Inserts.LIVING_ATTACK.insert(event.getEntity(), event.getSource(), event.getAmount()));
        forgeBus.addListener(event -> Inserts.LIVING_DEATH.insert(event.getEntity(), event.getSource()));
        forgeBus.addListener(event -> Inserts.LIVING_HEAL.insert(event.getEntity(), event.getAmount(), arg_0 -> ((LivingHealEvent)event).setAmount(arg_0)));
        forgeBus.addListener(event -> Inserts.ENTITY_JOIN_LEVEL.insert(event.getEntity(), event.getLevel(), event.loadedFromDisk()));
        forgeBus.addListener(event -> Inserts.ITEM_TOOLTIP.insert(event.getItemStack(), event.getEntity(), event.getToolTip(), event.getFlags()));
        forgeBus.addListener(event -> Inserts.FINISH_SLEEP.insert(event.getLevel(), event.getNewTime(), arg_0 -> ((SleepFinishedTimeEvent)event).setTimeAddition(arg_0)));
        forgeBus.addListener(evt -> Inserts.LOOT_TABLE_LOAD.insert(evt.getName(), evt.getTable(), arg_0 -> ((LootTableLoadEvent)evt).setTable(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.START) {
                Inserts.CLIENT_TICK_BEGIN.insert();
            }
            if (evt.phase == TickEvent.Phase.END) {
                Inserts.CLIENT_TICK_FINISH.insert();
            }
        });
        forgeBus.addListener(event -> Inserts.LEVEL_SAVE.insert(event.getLevel()));
        forgeBus.addListener(event -> Inserts.LEVEL_LOAD.insert(event.getLevel()));
        forgeBus.addListener(event -> Inserts.LIVING_JUMP.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LIVING_TICK.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.ITEM_USE_FINISH.insert(event.getEntity(), event.getItem(), event.getDuration(), event.getResultStack(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0)));
        forgeBus.addListener(event -> Inserts.MENU_CLOSE.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(event -> Inserts.MENU_OPEN.insert(event.getEntity(), event.getContainer()));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_ENTITY.insert(evt.getEntity(), evt.getHand(), evt.getTarget(), c -> {
            if (c.booleanValue()) {
                evt.setCanceled(true);
            }
        }, evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.EntityInteract)evt).setCancellationResult(arg_0)));
        forgeBus.addListener(evt -> Inserts.INTERACT_WITH_BLOCK.insert(evt.getEntity(), evt.getHand(), evt.getPos(), evt.getHitVec(), evt.getCancellationResult(), arg_0 -> ((PlayerInteractEvent.RightClickBlock)evt).setCancellationResult(arg_0), () -> evt.setCanceled(true)));
        forgeBus.addListener(event -> Inserts.PLAYER_RESTORE.insert(event.getEntity(), event.getOriginal(), !event.isWasDeath()));
        forgeBus.addListener(event -> Inserts.LOGGED_OUT.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.LOGGED_IN.insert(event.getEntity()));
        forgeBus.addListener(event -> Inserts.XP_PICKUP.insert(event.getEntity(), event.getOrb()));
    }

    public static void handleClientEvents() {
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(evt -> ClientInserts.SCREEN_RENDER_FINISH.insert(evt.getScreen(), evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY(), evt.getPartialTick()));
    }

    public static void handleRegistration(MinecraftMod mod, String namespace, Field[] fields, RegistryHolder reg, Logger LOGGER) {
        DeferredRegister BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)namespace);
        DeferredRegister FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)namespace);
        DeferredRegister ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)namespace);
        DeferredRegister CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)namespace);
        DeferredRegister ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)namespace);
        DeferredRegister MOB_EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)namespace);
        DeferredRegister ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)namespace);
        DeferredRegister SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)namespace);
        DeferredRegister SENSOR_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)namespace);
        DeferredRegister MENU_TYPE = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)namespace);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(RegistryObject.class)) continue;
            RegistryObject regi = field.getAnnotation(RegistryObject.class);
            String regName = regi.value();
            Consumer<Exception> exc = e -> {
                e.printStackTrace();
                LOGGER.warn("There was an error registering " + regName);
            };
            if (reg.registry() == Block.class) {
                BLOCKS.register(regName, () -> {
                    try {
                        return (Block)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Fluid.class) {
                FLUIDS.register(regName, () -> {
                    try {
                        return (Fluid)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Enchantment.class) {
                ENCHANTMENTS.register(regName, () -> {
                    try {
                        return (Enchantment)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Item.class) {
                ITEMS.register(regName, () -> {
                    try {
                        return (Item)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == MobEffect.class) {
                MOB_EFFECTS.register(regName, () -> {
                    try {
                        return (MobEffect)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == Attribute.class) {
                ATTRIBUTES.register(regName, () -> {
                    try {
                        return (Attribute)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == RecipeSerializer.class) {
                SERIALIZERS.register(regName, () -> {
                    try {
                        return (RecipeSerializer)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == SensorType.class) {
                SENSOR_TYPE.register(regName, () -> {
                    try {
                        return (SensorType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            if (reg.registry() == MenuType.class) {
                MENU_TYPE.register(regName, () -> {
                    try {
                        return (MenuType)field.get(null);
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        exc.accept(e);
                        return null;
                    }
                });
                continue;
            }
            throw new UnsupportedOperationException("No registry exists for the object \"" + reg.registry().getSimpleName() + ".class\".");
        }
        if (ModHandler.mods.get(mod.getModid()).eventBus() != null || FMLJavaModLoadingContext.get() != null) {
            IEventBus modEventBus = ModHandler.mods.get(mod.getModid()).eventBus() != null ? ModHandler.mods.get(mod.getModid()).eventBus() : FMLJavaModLoadingContext.get().getModEventBus();
            BLOCKS.register(modEventBus);
            FLUIDS.register(modEventBus);
            ITEMS.register(modEventBus);
            ENCHANTMENTS.register(modEventBus);
            MOB_EFFECTS.register(modEventBus);
            SERIALIZERS.register(modEventBus);
            ATTRIBUTES.register(modEventBus);
            MENU_TYPE.register(modEventBus);
            CreativeTabBuilder builders = (name, tab) -> {
                if (tab != null) {
                    CREATIVE_MODE_TABS.register(name, () -> tab);
                }
            };
            mod.registerCreativeTabs(builders);
            CREATIVE_MODE_TABS.register(modEventBus);
        }
    }
}

