/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.network.protocol.game;

import com.stereowalker.unionlib.network.protocol.game.BasePacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class ClientboundUnionPacket
extends BasePacket {
    public ClientboundUnionPacket(SimpleChannel channel) {
        super(channel);
    }

    public ClientboundUnionPacket(FriendlyByteBuf packetBuffer, SimpleChannel channel) {
        super(packetBuffer, channel);
    }

    @Override
    public void message(Supplier<NetworkEvent.Context> contextSupplier) {
        MutableBoolean wasHandled = new MutableBoolean();
        if (this.shouldRun()) {
            contextSupplier.get().enqueueWork(() -> wasHandled.setValue((Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> this.handleOnClient(Minecraft.m_91087_().f_91074_))));
            contextSupplier.get().setPacketHandled(true);
            if (this.verifyIfHandled()) {
                System.out.println(wasHandled.booleanValue() + " Packet Handled = " + contextSupplier.get().getPacketHandled());
            }
        }
    }

    public boolean verifyIfHandled() {
        return false;
    }

    public boolean shouldRun() {
        return true;
    }

    public abstract boolean handleOnClient(LocalPlayer var1);

    public void send(ServerPlayer playerEntity) {
        this.channel.sendTo((Object)this, playerEntity.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public void send(ServerLevel world) {
        for (ServerPlayer playerEntity : world.m_6907_()) {
            this.send(playerEntity);
        }
    }

    public void send(MinecraftServer server) {
        for (ServerPlayer playerEntity : server.m_6846_().m_11314_()) {
            this.send(playerEntity);
        }
    }
}

