/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stereowalker.unionlib.world.item.crafting.URecipeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class NoRemainderShaplessRecipe
extends ShapelessRecipe {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;

    public NoRemainderShaplessRecipe(ResourceLocation pId, String pGroup, CraftingBookCategory pCategory, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        super(pId, pGroup, pCategory, pResult, pIngredients);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        return nonnulllist;
    }

    public RecipeSerializer<?> m_7707_() {
        return URecipeSerializer.NO_REMAINDER_SHAPELESS_RECIPE;
    }

    public static class Serializer
    implements RecipeSerializer<NoRemainderShaplessRecipe> {
        public NoRemainderShaplessRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > MAX_WIDTH * MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is " + MAX_WIDTH * MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new NoRemainderShaplessRecipe(pRecipeId, s, craftingbookcategory, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray pIngredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < pIngredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)pIngredientArray.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public NoRemainderShaplessRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
            int i = pBuffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack itemstack = pBuffer.m_130267_();
            return new NoRemainderShaplessRecipe(pRecipeId, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, NoRemainderShaplessRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.m_6076_());
            pBuffer.m_130068_((Enum)pRecipe.m_245232_());
            pBuffer.m_130130_(pRecipe.m_7527_().size());
            for (Ingredient ingredient : pRecipe.m_7527_()) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.m_8043_(null));
        }
    }
}

