/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.codecs.predicates.NbtPredicate;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public record RestrictedEntityPredicate(EntityType<?> entityType, LocationPredicate location, MobEffectsPredicate effects, NbtPredicate nbt, EntityFlagsPredicate flags, EntityPredicate targetedEntity) {
    public static final Codec<RestrictedEntityPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256780_.m_194605_().fieldOf("type").forGetter(RestrictedEntityPredicate::entityType), (App)CodecExtras.passthrough(LocationPredicate::m_52616_, LocationPredicate::m_52629_).fieldOf("location").orElse((Object)LocationPredicate.f_52592_).forGetter(RestrictedEntityPredicate::location), (App)CodecExtras.passthrough(MobEffectsPredicate::m_56565_, MobEffectsPredicate::m_56559_).fieldOf("effects").orElse((Object)MobEffectsPredicate.f_56547_).forGetter(RestrictedEntityPredicate::effects), (App)NbtPredicate.CODEC.fieldOf("nbt").orElse((Object)NbtPredicate.ANY).forGetter(RestrictedEntityPredicate::nbt), (App)CodecExtras.passthrough(EntityFlagsPredicate::m_33695_, EntityFlagsPredicate::m_33698_).fieldOf("flags").orElse((Object)EntityFlagsPredicate.f_33682_).forGetter(RestrictedEntityPredicate::flags), (App)CodecExtras.passthrough(EntityPredicate::m_36606_, EntityPredicate::m_36614_).fieldOf("target").orElse((Object)EntityPredicate.f_36550_).forGetter(RestrictedEntityPredicate::targetedEntity)).apply((Applicative)instance, RestrictedEntityPredicate::new));

    public Optional<CompoundTag> getTag() {
        if (this.nbt() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.nbt().tag());
    }

    public boolean matches(ServerLevel level, Entity entity) {
        LivingEntity livingEntity;
        if (this.entityType == null) {
            return false;
        }
        if (this.entityType != entity.m_6095_()) {
            return false;
        }
        if (!this.location.m_52617_(level, entity.m_20185_(), entity.m_20186_(), entity.m_20189_())) {
            return false;
        }
        if (!this.effects.m_56555_(entity)) {
            return false;
        }
        if (!this.nbt.matches(entity)) {
            return false;
        }
        if (!this.flags.m_33696_(entity)) {
            return false;
        }
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            livingEntity = mob.m_5448_();
        } else {
            livingEntity = null;
        }
        return this.targetedEntity.m_36607_(level, null, livingEntity);
    }
}

