/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Lifecycle;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.ContextualRecipeCondition;
import dev.kir.smartrecipes.api.ModEntry;
import dev.kir.smartrecipes.api.RecipeCondition;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.RegistryEntry;
import dev.kir.smartrecipes.util.JsonUtil;
import dev.kir.smartrecipes.util.world.TimeOfDay;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

final class RecipeConditions {
    public static final class_5321<class_2378<RecipeCondition>> KEY = class_5321.method_29180((class_2960)SmartRecipes.locate("recipe_condition"));
    public static final class_2378<RecipeCondition> REGISTRY = new class_2370(KEY, Lifecycle.experimental());
    public static final RecipeCondition FALSE = (e, i) -> false;
    public static final RecipeCondition TRUE = (e, i) -> true;
    public static final RecipeCondition COMMENT = (e, i) -> true;
    public static final RecipeCondition _COMMENT = (e, i) -> false;
    public static final RecipeCondition OR = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The OR operator requires at least one argument. Consider using ANY instead.");
        }
        do {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            return true;
        } while (iterator.hasNext());
        return false;
    };
    public static final RecipeCondition AND = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The AND operator requires at least one argument. Consider using ALL instead.");
        }
        do {
            if (((Boolean)iterator.next()).booleanValue()) continue;
            return false;
        } while (iterator.hasNext());
        return true;
    };
    public static final RecipeCondition NOT = (e, i) -> {
        Iterator iterator = RecipeConditions.test(e, i).iterator();
        if (!iterator.hasNext()) {
            throw new JsonSyntaxException("The NOT operator requires at least one argument. Consider using NONE instead.");
        }
        do {
            if (!((Boolean)iterator.next()).booleanValue()) continue;
            return false;
        } while (iterator.hasNext());
        return true;
    };
    public static final RecipeCondition ANY = (e, i) -> RecipeConditions.test(e, i).anyMatch(x -> x);
    public static final RecipeCondition ALL = (e, i) -> RecipeConditions.test(e, i).allMatch(x -> x);
    public static final RecipeCondition NONE = (e, i) -> RecipeConditions.test(e, i).noneMatch(x -> x);
    public static final ContextualRecipeCondition IS_HARDCORE = (e, ctx) -> ctx.getServer().method_3754();
    public static final ContextualRecipeCondition DIFFICULTY_CHECK = (e, ctx) -> JsonUtil.flatMap(e).map(RecipeConditions::parseDifficulty).anyMatch(arg_0 -> ctx.getServer().method_27728().method_207().equals(arg_0));
    public static final ContextualRecipeCondition IS_PEACEFUL_DIFFICULTY = (e, ctx) -> class_1267.field_5801.equals((Object)ctx.getServer().method_27728().method_207());
    public static final ContextualRecipeCondition IS_EASY_DIFFICULTY = (e, ctx) -> class_1267.field_5805.equals((Object)ctx.getServer().method_27728().method_207());
    public static final ContextualRecipeCondition IS_NORMAL_DIFFICULTY = (e, ctx) -> class_1267.field_5802.equals((Object)ctx.getServer().method_27728().method_207());
    public static final ContextualRecipeCondition IS_HARD_DIFFICULTY = (e, ctx) -> class_1267.field_5807.equals((Object)ctx.getServer().method_27728().method_207());
    public static final ContextualRecipeCondition GAMEMODE_CHECK = (e, ctx) -> JsonUtil.flatMap(e).map(RecipeConditions::parseGameMode).anyMatch(arg_0 -> ctx.getServer().method_3790().equals(arg_0));
    public static final ContextualRecipeCondition IS_SURVIVAL = (e, ctx) -> class_1934.field_9215.equals((Object)ctx.getServer().method_3790());
    public static final ContextualRecipeCondition IS_CREATIVE = (e, ctx) -> class_1934.field_9220.equals((Object)ctx.getServer().method_3790());
    public static final ContextualRecipeCondition IS_ADVENTURE = (e, ctx) -> class_1934.field_9216.equals((Object)ctx.getServer().method_3790());
    public static final ContextualRecipeCondition IS_SPECTATOR = (e, ctx) -> class_1934.field_9219.equals((Object)ctx.getServer().method_3790());
    public static final ContextualRecipeCondition WEATHER_CHECK = (e, ctx) -> {
        boolean clear = false;
        boolean rain = false;
        boolean thunder = false;
        for (String weatherId : JsonUtil.flatMap(e).map(JsonPrimitive::getAsString)::iterator) {
            if ((weatherId = weatherId.toLowerCase()).startsWith("clea")) {
                clear = true;
                continue;
            }
            if (weatherId.startsWith("rain")) {
                rain = true;
                continue;
            }
            if (!weatherId.startsWith("thunder")) continue;
            thunder = true;
        }
        class_5217 worldProperties = ctx.getServer().method_30002().method_8401();
        return clear && !worldProperties.method_156() || rain && worldProperties.method_156() || thunder && worldProperties.method_203();
    };
    public static final ContextualRecipeCondition TIME_CHECK = (e, ctx) -> {
        TimeOfDay time = TimeOfDay.fromTime(ctx.getServer().method_30002().method_8532());
        return JsonUtil.flatMap(e).map(RecipeConditions::parseTimeOfDay).anyMatch(x -> x.contains(time));
    };
    public static final ContextualRecipeCondition PLAYERS_ONLINE = (e, ctx) -> {
        List<String> names = Arrays.asList(ctx.getServer().method_3858());
        return JsonUtil.flatMap(e).allMatch(x -> names.contains(x.getAsString()));
    };
    public static final RecipeCondition ENTRIES_REGISTERED = (e, i) -> JsonUtil.flatMap(e, RegistryEntry::parse, RegistryEntry::parse).allMatch(x -> {
        class_2378 registry = (class_2378)class_7923.field_41167.method_10223(new class_2960(x.registry()));
        return registry != null && registry.method_10250(new class_2960(x.entry()));
    });
    public static final RecipeCondition BLOCKS_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> class_7923.field_41175.method_10250(new class_2960(x.getAsString())));
    public static final RecipeCondition ITEMS_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> class_7923.field_41178.method_10250(new class_2960(x.getAsString())));
    public static final RecipeCondition BLOCK_ENTITIES_REGISTERED = (e, i) -> JsonUtil.flatMap(e).allMatch(x -> class_7923.field_41181.method_10250(new class_2960(x.getAsString())));
    public static final RecipeCondition MODS_LOADED = (e, i) -> JsonUtil.flatMap(e, ModEntry::parse, ModEntry::parse).allMatch(x -> {
        ModContainer mod = FabricLoader.getInstance().getModContainer(x.id()).orElse(null);
        if (mod == null) {
            return false;
        }
        try {
            return VersionPredicate.parse((String)x.version()).test((Object)mod.getMetadata().getVersion());
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    });

    RecipeConditions() {
    }

    private static Stream<Boolean> test(JsonElement element, RecipeInfo info) {
        JsonPrimitive primitive;
        if (RecipeCondition.isConditionBody(element)) {
            return Stream.of(Boolean.valueOf(RecipeCondition.test((JsonObject)element, info)));
        }
        if (element instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)element;
            return jsonObject.entrySet().stream().map(entry -> RecipeCondition.test((String)entry.getKey(), (JsonElement)entry.getValue(), info));
        }
        if (element instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)element;
            return StreamSupport.stream(jsonArray.spliterator(), false).flatMap(e -> RecipeConditions.test(e, info));
        }
        if (element instanceof JsonPrimitive && (primitive = (JsonPrimitive)element).isString()) {
            return Stream.of(Boolean.valueOf(RecipeCondition.test(primitive.getAsString(), null, info)));
        }
        return Stream.of(Boolean.valueOf(JsonUtil.asBoolean(element)));
    }

    private static class_1267 parseDifficulty(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? class_1267.method_5462((int)jsonPrimitive.getAsInt()) : class_1267.method_16691((String)jsonPrimitive.getAsString().toLowerCase());
    }

    private static class_1934 parseGameMode(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? class_1934.method_8384((int)jsonPrimitive.getAsInt()) : class_1934.method_8385((String)jsonPrimitive.getAsString().toLowerCase());
    }

    private static TimeOfDay parseTimeOfDay(JsonPrimitive jsonPrimitive) {
        return jsonPrimitive.isNumber() ? TimeOfDay.fromTime(jsonPrimitive.getAsLong()) : TimeOfDay.byName(jsonPrimitive.getAsString().toLowerCase());
    }
}

