/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.api.networking;

import com.google.gson.JsonObject;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import dev.kir.smartrecipes.util.recipe.RecipeBookUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1865;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3439;
import net.minecraft.class_3545;
import net.minecraft.class_3956;
import net.minecraft.class_634;
import net.minecraft.class_7923;

public class SynchronizeReloadedRecipesPacket {
    public static final class_2960 ID = SmartRecipes.locate("packet.sync.recipes");
    private final Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> reloadedRecipes;

    public SynchronizeReloadedRecipesPacket(Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> reloadedRecipes) {
        this.reloadedRecipes = reloadedRecipes;
    }

    public SynchronizeReloadedRecipesPacket(class_2540 buf) {
        this.reloadedRecipes = buf.method_34066(SynchronizeReloadedRecipesPacket::readRecipeEntry);
    }

    public void write(class_2540 buf) {
        buf.method_34062(this.reloadedRecipes, SynchronizeReloadedRecipesPacket::writeRecipeEntry);
    }

    @Environment(value=EnvType.CLIENT)
    public void apply(class_310 client, class_634 handler) {
        class_299 recipeBook;
        class_1863 recipeManager = handler.method_2877();
        ((ReloadableRecipeManager)recipeManager).apply(this.reloadedRecipes);
        class_299 class_2992 = recipeBook = client.field_1724 == null ? null : client.field_1724.method_3130();
        if (recipeBook != null) {
            RecipeBookUtil.apply((class_3439)recipeBook, handler.method_29091(), this.reloadedRecipes);
        }
    }

    public void send(Stream<class_3222> players) {
        class_2540 buffer = PacketByteBufs.create();
        this.write(buffer);
        players.forEach(player -> ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buffer));
    }

    private static <T extends class_1860<?>> void writeRecipeEntry(class_2540 buf, class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo> recipeEntry) {
        ReloadableRecipeManager.RecipeState state = (ReloadableRecipeManager.RecipeState)((Object)recipeEntry.method_15442());
        RecipeInfo recipeInfo = (RecipeInfo)recipeEntry.method_15441();
        if (state == ReloadableRecipeManager.RecipeState.KEEP) {
            class_1860<?> recipe = recipeInfo.getRecipe().orElseThrow(() -> new IllegalArgumentException("Unable to parse recipe '" + recipeInfo.getRecipeId() + "'"));
            buf.writeBoolean(true);
            buf.method_10812(class_7923.field_41189.method_10221((Object)recipe.method_8119()));
            buf.method_10812(recipe.method_8114());
            recipe.method_8119().method_8124(buf, recipe);
        } else {
            buf.writeBoolean(false);
            buf.method_10812(recipeInfo.getRecipeId());
            buf.method_10812(class_7923.field_41188.method_10221(recipeInfo.getRecipeType().orElseThrow(() -> new IllegalArgumentException("Recipe '" + recipeInfo.getRecipeId() + "' uses invalid or unsupported recipe type"))));
        }
    }

    private static class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo> readRecipeEntry(class_2540 buf) {
        if (buf.readBoolean()) {
            class_2960 serializerId = buf.method_10810();
            class_1865 serializer = (class_1865)class_7923.field_41189.method_17966(serializerId).orElseThrow(() -> new IllegalArgumentException("Unknown recipe serializer " + serializerId));
            class_2960 recipeId = buf.method_10810();
            class_1860 recipe = serializer.method_8122(recipeId, buf);
            return new class_3545((Object)ReloadableRecipeManager.RecipeState.KEEP, (Object)new SerializableRecipeInfo(recipeId, recipe));
        }
        class_2960 recipeId = buf.method_10810();
        class_2960 recipeTypeId = buf.method_10810();
        class_3956 recipeType = (class_3956)class_7923.field_41188.method_17966(recipeTypeId).orElseThrow(() -> new IllegalArgumentException("Invalid or unsupported recipe type '" + recipeTypeId + "'"));
        return new class_3545((Object)ReloadableRecipeManager.RecipeState.REMOVE, (Object)new SerializableRecipeInfo(recipeId, recipeType));
    }

    private static class SerializableRecipeInfo
    extends RecipeInfo {
        private final class_1860<?> recipe;
        private final class_3956<?> recipeType;

        public SerializableRecipeInfo(class_2960 recipeId, class_3956<?> recipeType) {
            super(recipeId, null);
            this.recipe = null;
            this.recipeType = recipeType;
        }

        public SerializableRecipeInfo(class_2960 recipeId, class_1860<?> recipe) {
            super(recipeId, null);
            this.recipe = recipe;
            this.recipeType = null;
        }

        @Override
        public Optional<class_1860<?>> getRecipe() {
            return Optional.ofNullable(this.recipe);
        }

        @Override
        public Optional<class_3956<?>> getRecipeType() {
            return this.recipeType == null ? this.getRecipe().map(class_1860::method_17716) : Optional.of(this.recipeType);
        }

        @Override
        public JsonObject getRecipeAsJson() {
            throw new IllegalStateException("JSON is not available on the client side");
        }
    }
}

