/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.kir.smartrecipes.SmartRecipes;
import dev.kir.smartrecipes.api.RecipeCondition;
import dev.kir.smartrecipes.api.RecipeContext;
import dev.kir.smartrecipes.api.RecipeContextRequiredException;
import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.RecipeReloadCondition;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import dev.kir.smartrecipes.api.networking.SynchronizeReloadedRecipesPacket;
import dev.kir.smartrecipes.util.JsonUtil;
import dev.kir.smartrecipes.util.recipe.RecipeBookUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3439;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1863.class})
class RecipeManagerMixin
implements ReloadableRecipeManager {
    @Unique
    private static final class_2960 CONDITIONS = SmartRecipes.locate("conditions");
    @Unique
    private static final class_2960 OBSOLETE_CONDITIONS = new class_2960("conditions");
    @Unique
    private static final class_2960 RELOAD_CONDITIONS = SmartRecipes.locate("reload_conditions");
    @Unique
    private static final class_2960 OBSOLETE_RELOAD_CONDITIONS = new class_2960("reload_conditions");
    @Shadow
    private Map<class_3956<?>, Map<class_2960, class_1860<?>>> field_9023;
    @Unique
    private Map<class_2960, Collection<Map.Entry<class_2960, JsonElement>>> waitingForReload;

    RecipeManagerMixin() {
    }

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/profiler/Profiler;)V"}, at={@At(value="HEAD")})
    private void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        this.waitingForReload = new ConcurrentHashMap<class_2960, Collection<Map.Entry<class_2960, JsonElement>>>();
        int skipped = 0;
        class_2960 defaultContextualConditionId = RecipeReloadCondition.END_DATA_PACK_RELOAD.getId();
        Iterator<Map.Entry<class_2960, JsonElement>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<class_2960, JsonElement> entry = iterator.next();
            if (!entry.getValue().isJsonObject()) continue;
            class_2960 recipeId = entry.getKey();
            JsonObject recipeObject = entry.getValue().getAsJsonObject();
            JsonElement conditions = JsonUtil.get(recipeObject, CONDITIONS);
            boolean isObsoleteEntry = false;
            if (conditions == null) {
                conditions = JsonUtil.get(recipeObject, OBSOLETE_CONDITIONS);
                isObsoleteEntry = true;
            }
            if (conditions == null) continue;
            Stream<Object> reloadConditions = Stream.empty();
            try {
                if (!RecipeCondition.ALL.test(conditions, new RecipeInfo(recipeId, recipeObject))) {
                    iterator.remove();
                    ++skipped;
                }
            }
            catch (RecipeContextRequiredException e) {
                reloadConditions = Stream.of(defaultContextualConditionId);
            }
            catch (Throwable e) {
                if (!isObsoleteEntry) {
                    RecipeManagerMixin.logParsingError(recipeId, e);
                }
                isObsoleteEntry = false;
            }
            JsonElement definedReloadConditions = JsonUtil.get(recipeObject, RELOAD_CONDITIONS);
            if (definedReloadConditions == null) {
                definedReloadConditions = JsonUtil.get(recipeObject, OBSOLETE_RELOAD_CONDITIONS);
                isObsoleteEntry |= definedReloadConditions != null;
            }
            reloadConditions = Stream.concat(reloadConditions, JsonUtil.flatMap(definedReloadConditions).map(x -> class_2960.method_12829((String)x.getAsString())).filter(Objects::nonNull));
            for (class_2960 reloadConditionId : reloadConditions::iterator) {
                this.waitingForReload.computeIfAbsent(reloadConditionId, i -> ConcurrentHashMap.newKeySet()).add(entry);
            }
            if (!isObsoleteEntry || !SmartRecipes.CONFIG.getValue("debug").orElse(true).booleanValue()) continue;
            SmartRecipes.LOGGER.warn("{} uses obsolete '{}' and/or '{}' entries. Consider using '{}' and '{}' instead.", (Object)recipeId, (Object)OBSOLETE_CONDITIONS, (Object)OBSOLETE_RELOAD_CONDITIONS, (Object)CONDITIONS, (Object)RELOAD_CONDITIONS);
        }
        SmartRecipes.LOGGER.info("Skipped {} recipes", (Object)skipped);
    }

    @Override
    public void reload(MinecraftServer server, class_2960 cause) {
        Collection<Map.Entry<class_2960, JsonElement>> reloadableRecipes;
        Collection<Map.Entry<class_2960, JsonElement>> collection = reloadableRecipes = this.waitingForReload == null ? null : this.waitingForReload.get(cause);
        if (server == null || reloadableRecipes == null || reloadableRecipes.size() == 0) {
            return;
        }
        int reloaded = 0;
        int removed = 0;
        int added = 0;
        ArrayList<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff = new ArrayList<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>>();
        RecipeContext recipeContext = new RecipeContext(server, server.method_34864(), server.method_16044());
        for (Map.Entry<class_2960, JsonElement> entry : reloadableRecipes) {
            class_2960 recipeId = entry.getKey();
            try {
                boolean exists;
                boolean shouldExist;
                JsonObject recipeObject = entry.getValue().getAsJsonObject();
                RecipeContext recipeInfo = recipeContext.with(recipeId, recipeObject);
                JsonElement conditions = JsonUtil.get(recipeObject, CONDITIONS);
                if (conditions == null) {
                    conditions = JsonUtil.get(recipeObject, OBSOLETE_CONDITIONS);
                }
                if ((shouldExist = RecipeCondition.ALL.test(conditions, recipeInfo)) == (exists = this.field_9023.get(recipeInfo.getRecipeType().orElseThrow()).containsKey(recipeId))) continue;
                diff.add((class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>)new class_3545((Object)(shouldExist ? ReloadableRecipeManager.RecipeState.KEEP : ReloadableRecipeManager.RecipeState.REMOVE), (Object)recipeInfo));
                ++reloaded;
                if (shouldExist) {
                    ++added;
                    continue;
                }
                ++removed;
            }
            catch (Throwable e) {
                RecipeManagerMixin.logParsingError(recipeId, e);
            }
        }
        if (reloaded != 0) {
            this.apply(diff);
            this.sync(server, diff);
            SmartRecipes.LOGGER.info("Reloaded {} recipes (removed: {} | added: {}) on the '{}' event", (Object)reloaded, (Object)removed, (Object)added, (Object)cause);
        }
    }

    @Override
    public void apply(Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        if (diff.isEmpty()) {
            return;
        }
        Map<class_3956<?>, Map<class_2960, class_1860<?>>> mutableRecipes = RecipeManagerMixin.makeMutable(this.field_9023);
        for (class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo> entry : diff) {
            ReloadableRecipeManager.RecipeState recipeState = (ReloadableRecipeManager.RecipeState)((Object)entry.method_15442());
            RecipeInfo recipeInfo = (RecipeInfo)entry.method_15441();
            class_2960 recipeId = recipeInfo.getRecipeId();
            try {
                class_3956<?> recipeType = recipeInfo.getRecipeType().orElseThrow(() -> new IllegalArgumentException("Recipe '" + recipeId + "' uses invalid or unsupported recipe type"));
                switch (recipeState) {
                    case KEEP: {
                        Map container = mutableRecipes.computeIfAbsent(recipeType, x -> new HashMap());
                        container.put(recipeId, recipeInfo.getRecipe().orElseThrow(() -> new IllegalArgumentException("Unable to parse recipe '" + recipeId + "'")));
                        break;
                    }
                    case REMOVE: {
                        Map container = mutableRecipes.get(recipeType);
                        if (container == null) break;
                        container.remove(recipeId);
                    }
                }
            }
            catch (Throwable e) {
                RecipeManagerMixin.logParsingError(recipeId, e);
            }
        }
        this.field_9023 = mutableRecipes;
    }

    @Unique
    private void sync(MinecraftServer server, Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        if (diff.isEmpty()) {
            return;
        }
        new SynchronizeReloadedRecipesPacket(diff).send(PlayerLookup.all((MinecraftServer)server).stream());
        PlayerLookup.all((MinecraftServer)server).forEach(x -> RecipeBookUtil.apply((class_3439)x.method_14253(), (class_5455)server.method_30611(), diff));
    }

    @Unique
    private static void logParsingError(class_2960 recipeId, Throwable error) {
        if (SmartRecipes.CONFIG.getValue("debug").orElse(true).booleanValue()) {
            SmartRecipes.LOGGER.error("Parsing error loading recipe {}", (Object)recipeId, (Object)error);
        }
    }

    @Unique
    private static Map<class_3956<?>, Map<class_2960, class_1860<?>>> makeMutable(Map<class_3956<?>, Map<class_2960, class_1860<?>>> recipes) {
        if (recipes instanceof HashMap) {
            return recipes;
        }
        return recipes.entrySet().stream().map(x -> new AbstractMap.SimpleEntry((class_3956)x.getKey(), new HashMap((Map)x.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }
}

