/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.mixin;

import dev.kir.smartrecipes.api.event.WorldStateEvents;
import dev.kir.smartrecipes.util.world.TimeOfDay;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.class_3949;
import net.minecraft.class_5268;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_8565;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3218.class})
abstract class ServerWorldMixin
extends class_1937 {
    @Final
    @Shadow
    private class_5268 field_24456;
    @Unique
    private boolean wasRaining;
    @Unique
    private boolean wasThundering;
    @Unique
    private TimeOfDay timeOfDay;

    protected ServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer server, Executor workerExecutor, class_32.class_5143 session, class_5268 properties, class_5321<?> worldKey, class_5363 dimensionOptions, class_3949 worldGenerationProgressListener, boolean debugWorld, long seed, List<?> spawners, boolean shouldTickTime, class_8565 randomSequencesState, CallbackInfo ci) {
        this.wasRaining = properties.method_156();
        this.wasThundering = properties.method_203();
        this.timeOfDay = TimeOfDay.fromTime(properties.method_217());
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tick(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (this.wasRaining != this.field_24456.method_156() || this.wasThundering != this.field_24456.method_203()) {
            ((WorldStateEvents.WeatherChanged)WorldStateEvents.WEATHER_CHANGED.invoker()).onWeatherChanged((class_3218)this);
            this.wasRaining = this.field_24456.method_156();
            this.wasThundering = this.field_24456.method_203();
        }
    }

    @Inject(method={"setTimeOfDay"}, at={@At(value="RETURN")})
    private void setTimeOfDay(long time, CallbackInfo ci) {
        TimeOfDay newTimeOfDay = TimeOfDay.fromTime(time);
        if (this.timeOfDay != newTimeOfDay) {
            ((WorldStateEvents.TimeOfDayChanged)WorldStateEvents.TIME_CHANGED.invoker()).onTimeOfDayChanged((class_3218)this, this.timeOfDay, newTimeOfDay);
            this.timeOfDay = newTimeOfDay;
        }
    }
}

