/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.util.recipe;

import dev.kir.smartrecipes.api.RecipeInfo;
import dev.kir.smartrecipes.api.ReloadableRecipeManager;
import java.util.Collection;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1124;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_3439;
import net.minecraft.class_3441;
import net.minecraft.class_3545;
import net.minecraft.class_366;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_516;
import net.minecraft.class_518;
import net.minecraft.class_5455;
import net.minecraft.class_634;

public final class RecipeBookUtil {
    public static void apply(class_3439 recipeBook, class_5455 registryManager, Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff) {
        RecipeBookUtil.apply(recipeBook, registryManager, diff, false);
    }

    public static void apply(class_3439 recipeBook, class_5455 registryManager, Collection<class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo>> diff, boolean showRecipeToasts) {
        if (diff.isEmpty()) {
            return;
        }
        boolean isClient = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
        for (class_3545<ReloadableRecipeManager.RecipeState, RecipeInfo> entry : diff) {
            ReloadableRecipeManager.RecipeState recipeState = (ReloadableRecipeManager.RecipeState)((Object)entry.method_15442());
            RecipeInfo recipeInfo = (RecipeInfo)entry.method_15441();
            class_2960 recipeId = recipeInfo.getRecipeId();
            if (recipeState == ReloadableRecipeManager.RecipeState.KEEP && recipeInfo.getRecipe().isPresent()) {
                class_1860<?> recipe = recipeInfo.getRecipe().get();
                if (showRecipeToasts && isClient && !(recipeBook instanceof class_3441) && !recipeBook.method_22845(recipeId)) {
                    recipeBook.method_14885(recipe);
                    RecipeBookUtil.showRecipeToast(recipe);
                }
                recipeBook.method_14876(recipe);
                continue;
            }
            recipeBook.method_14879(recipeId);
        }
        if (isClient) {
            RecipeBookUtil.refreshRecipeBook(recipeBook, registryManager);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void refreshRecipeBook(class_3439 recipeBook, class_5455 registryManager) {
        class_437 class_4372;
        if (!(recipeBook instanceof class_299)) {
            return;
        }
        class_299 clientRecipeBook = (class_299)recipeBook;
        class_310 client = class_310.method_1551();
        class_634 network = class_310.method_1551().method_1562();
        if (network != null) {
            clientRecipeBook.method_1401((Iterable)network.method_2877().method_8126(), registryManager);
            for (class_516 collection : clientRecipeBook.method_1393()) {
                collection.method_2647((class_3439)clientRecipeBook);
            }
            client.method_43759(class_1124.field_5496, clientRecipeBook.method_1393());
        }
        if ((class_4372 = class_310.method_1551().field_1755) instanceof class_518) {
            class_518 recipeBookProvider = (class_518)class_4372;
            recipeBookProvider.method_16891();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void showRecipeToast(class_1860<?> recipe) {
        class_366.method_1985((class_374)class_310.method_1551().method_1566(), recipe);
    }
}

