/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.smartrecipes.util.world;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TimeOfDay implements class_3542
{
    DAY("day", 1000L, 12999L),
    NOON("noon", 5000L, 6999L),
    SUNSET("sunset", 11000L, 12999L),
    MIDNIGHT("midnight", 17000L, 18999L),
    SUNRISE("sunrise", 22000L, 23999L),
    NIGHT("night", 13000L, 23999L){

        @Override
        public boolean contains(long time) {
            return !DAY.contains(time);
        }
    };

    public static final int TICKS_PER_DAY = 24000;
    private static final Map<String, TimeOfDay> BY_NAME;
    private final String name;
    private final long from;
    private final long to;

    private TimeOfDay(String name, long from, long to) {
        this.name = name;
        this.from = from;
        this.to = to;
    }

    public boolean contains(long time) {
        return time >= this.from && time <= this.to;
    }

    public boolean contains(TimeOfDay time) {
        return this.contains(time.from) && this.contains(time.to);
    }

    public String method_15434() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Nullable
    public static TimeOfDay byName(String name) {
        return BY_NAME.get(name);
    }

    public static TimeOfDay fromTime(long time) {
        if (DAY.contains(time = (time + 24000L) % 24000L)) {
            if (NOON.contains(time)) {
                return NOON;
            }
            if (SUNSET.contains(time)) {
                return SUNSET;
            }
            return DAY;
        }
        if (MIDNIGHT.contains(time)) {
            return MIDNIGHT;
        }
        if (SUNRISE.contains(time)) {
            return SUNRISE;
        }
        return NIGHT;
    }

    static {
        BY_NAME = Arrays.stream(TimeOfDay.values()).collect(Collectors.toMap(x -> x.name, x -> x));
    }
}

