/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.impl.SimpleItemEnergyStorageImpl;

public interface SimpleEnergyItem {
    public static final String ENERGY_KEY = "energy";

    public static EnergyStorage createStorage(ContainerItemContext ctx, long capacity, long maxInsert, long maxExtract) {
        return SimpleItemEnergyStorageImpl.createSimpleStorage(ctx, capacity, maxInsert, maxExtract);
    }

    public long getEnergyCapacity(ItemStack var1);

    public long getEnergyMaxInput(ItemStack var1);

    public long getEnergyMaxOutput(ItemStack var1);

    default public long getStoredEnergy(ItemStack stack) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(stack);
    }

    default public void setStoredEnergy(ItemStack stack, long newAmount) {
        SimpleEnergyItem.setStoredEnergyUnchecked(stack, newAmount);
    }

    default public boolean tryUseEnergy(ItemStack stack, long amount) {
        if (stack.m_41613_() != 1) {
            throw new IllegalArgumentException("Invalid count: " + stack.m_41613_());
        }
        long newAmount = this.getStoredEnergy(stack) - amount;
        if (newAmount < 0L) {
            return false;
        }
        this.setStoredEnergy(stack, newAmount);
        return true;
    }

    public static long getStoredEnergyUnchecked(ItemStack stack) {
        return SimpleEnergyItem.getStoredEnergyUnchecked(stack.m_41783_());
    }

    public static long getStoredEnergyUnchecked(@Nullable CompoundTag nbt) {
        return nbt != null ? nbt.m_128454_(ENERGY_KEY) : 0L;
    }

    public static void setStoredEnergyUnchecked(ItemStack stack, long newAmount) {
        if (newAmount == 0L) {
            stack.m_41749_(ENERGY_KEY);
        } else {
            stack.m_41784_().m_128356_(ENERGY_KEY, newAmount);
        }
    }
}

