/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation.init.data.worldgen;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.common.world.ConfigPlacementFilter;
import cofh.thermal.core.util.RegistrationHelper;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.AcaciaFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.MegaJungleFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.MegaJungleTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class TFndFeatures {

    public static class Placed {
        public static final ResourceKey<PlacedFeature> APATITE_ORE = Placed.createKey("apatite_ore");
        public static final ResourceKey<PlacedFeature> CINNABAR_ORE = Placed.createKey("cinnabar_ore");
        public static final ResourceKey<PlacedFeature> NITER_ORE = Placed.createKey("niter_ore");
        public static final ResourceKey<PlacedFeature> SULFUR_ORE = Placed.createKey("sulfur_ore");
        public static final ResourceKey<PlacedFeature> LEAD_ORE = Placed.createKey("lead_ore");
        public static final ResourceKey<PlacedFeature> NICKEL_ORE = Placed.createKey("nickel_ore");
        public static final ResourceKey<PlacedFeature> SILVER_ORE = Placed.createKey("silver_ore");
        public static final ResourceKey<PlacedFeature> TIN_ORE = Placed.createKey("tin_ore");
        public static final ResourceKey<PlacedFeature> OIL_SAND = Placed.createKey("oil_sand");
        public static final ResourceKey<PlacedFeature> RUBBERWOOD_TREE_CHECKED = Placed.createKey("rubberwood_tree");
        public static final ResourceKey<PlacedFeature> MEGA_RUBBERWOOD_TREE_CHECKED = Placed.createKey("mega_rubberwood_tree");
        public static final ResourceKey<PlacedFeature> TREES_RUBBERWOOD_PLACED = Placed.createKey("trees_rubberwood");

        public static void init(BootstapContext<PlacedFeature> context) {
            HolderGetter features = context.m_255420_(Registries.f_256911_);
            context.m_255272_(APATITE_ORE, (Object)Placed.placedOreTriangle(features, Configured.APATITE_ORE, "apatite_ore", -16, 96, 3));
            context.m_255272_(CINNABAR_ORE, (Object)Placed.placedOreTriangle(features, Configured.CINNABAR_ORE, "cinnabar_ore", -16, 48, 1));
            context.m_255272_(NITER_ORE, (Object)Placed.placedOreTriangle(features, Configured.NITER_ORE, "niter_ore", -16, 64, 2));
            context.m_255272_(SULFUR_ORE, (Object)Placed.placedOreTriangle(features, Configured.SULFUR_ORE, "sulfur_ore", -16, 32, 2));
            context.m_255272_(LEAD_ORE, (Object)Placed.placedOreUniform(features, Configured.LEAD_ORE, "lead_ore", -60, 40, 6));
            context.m_255272_(NICKEL_ORE, (Object)Placed.placedOreUniform(features, Configured.NICKEL_ORE, "nickel_ore", -40, 120, 4));
            context.m_255272_(SILVER_ORE, (Object)Placed.placedOreUniform(features, Configured.SILVER_ORE, "silver_ore", -60, 40, 4));
            context.m_255272_(TIN_ORE, (Object)Placed.placedOreUniform(features, Configured.TIN_ORE, "tin_ore", -20, 60, 6));
            context.m_255272_(OIL_SAND, (Object)Placed.placedOreUniform(features, Configured.OIL_SAND, "oil_sand", 40, 80, 2));
            context.m_255272_(RUBBERWOOD_TREE_CHECKED, (Object)Placed.checkTree(features, Configured.RUBBERWOOD_TREE, "rubberwood_sapling"));
            context.m_255272_(MEGA_RUBBERWOOD_TREE_CHECKED, (Object)Placed.checkTree(features, Configured.MEGA_RUBBERWOOD_TREE, "rubberwood_sapling"));
            context.m_255272_(TREES_RUBBERWOOD_PLACED, (Object)Placed.placedTree(features, Configured.TREES_RUBBERWOOD, "rubberwood_trees", 0, 0.25f, 1));
        }

        private static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("thermal", name));
        }

        private static PlacedFeature registerPlacedFeature(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
            return new PlacedFeature((Holder)getter.m_255043_(feature), List.of(modifiers));
        }

        private static PlacedFeature placedOreTriangle(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> ore, String name, int minY, int maxY, int count) {
            return Placed.registerPlacedFeature(getter, ore, new PlacementModifier[]{new ConfigPlacementFilter(name), CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()});
        }

        private static PlacedFeature placedOreUniform(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> ore, String name, int minY, int maxY, int count) {
            return Placed.registerPlacedFeature(getter, ore, new PlacementModifier[]{new ConfigPlacementFilter(name), CountPlacement.m_191628_((int)count), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)minY), (VerticalAnchor)VerticalAnchor.m_158922_((int)maxY)), BiomeFilter.m_191561_()});
        }

        private static PlacedFeature checkTree(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> feature, String sapling) {
            return new PlacedFeature((Holder)getter.m_255043_(feature), List.of(PlacementUtils.m_206493_((Block)((Block)ThermalCore.BLOCKS.getSup(sapling).get()))));
        }

        public static PlacedFeature placedTree(HolderGetter<ConfiguredFeature<?, ?>> getter, ResourceKey<ConfiguredFeature<?, ?>> tree, String name, int count, float chance, int extra) {
            return Placed.registerPlacedFeature(getter, tree, new PlacementModifier[]{new ConfigPlacementFilter(name), PlacementUtils.m_195364_((int)count, (float)chance, (int)extra), InSquarePlacement.m_191715_(), SurfaceWaterDepthFilter.m_191950_((int)0), PlacementUtils.f_195355_, BiomeFilter.m_191561_()});
        }
    }

    public static class Configured {
        public static final ResourceKey<ConfiguredFeature<?, ?>> APATITE_ORE = Configured.createKey("apatite_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> CINNABAR_ORE = Configured.createKey("cinnabar_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NITER_ORE = Configured.createKey("niter_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SULFUR_ORE = Configured.createKey("sulfur_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = Configured.createKey("lead_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NICKEL_ORE = Configured.createKey("nickel_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = Configured.createKey("silver_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE = Configured.createKey("tin_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> OIL_SAND = Configured.createKey("oil_sand");
        public static final ResourceKey<ConfiguredFeature<?, ?>> RUBBERWOOD_TREE = Configured.createKey("rubberwood_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> MEGA_RUBBERWOOD_TREE = Configured.createKey("mega_rubberwood_tree");
        public static final ResourceKey<ConfiguredFeature<?, ?>> TREES_RUBBERWOOD = Configured.createKey("trees_rubberwood");

        public static void init(BootstapContext<ConfiguredFeature<?, ?>> context) {
            TagMatchTest baseStoneOverworld = new TagMatchTest(BlockTags.f_13061_);
            TagMatchTest baseStoneNether = new TagMatchTest(BlockTags.f_13062_);
            TagMatchTest stoneOre = new TagMatchTest(BlockTags.f_144266_);
            TagMatchTest deepslateOre = new TagMatchTest(BlockTags.f_144267_);
            BlockMatchTest netherrack = new BlockMatchTest(Blocks.f_50134_);
            BlockMatchTest sand = new BlockMatchTest(Blocks.f_49992_);
            BlockMatchTest redSand = new BlockMatchTest(Blocks.f_49993_);
            List<OreConfiguration.TargetBlockState> apatite = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("apatite_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"apatite_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> cinnabar = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("cinnabar_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"cinnabar_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> niter = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("niter_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"niter_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> sulfur = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("sulfur_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"sulfur_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> lead = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("lead_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"lead_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> nickel = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("nickel_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"nickel_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> silver = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("silver_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"silver_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> tin = List.of(OreConfiguration.m_161021_((RuleTest)stoneOre, (BlockState)((Block)ThermalCore.BLOCKS.get("tin_ore")).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateOre, (BlockState)((Block)ThermalCore.BLOCKS.get(RegistrationHelper.deepslate((String)"tin_ore"))).m_49966_()));
            List<OreConfiguration.TargetBlockState> oilSand = List.of(OreConfiguration.m_161021_((RuleTest)sand, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_sand")).m_49966_()), OreConfiguration.m_161021_((RuleTest)redSand, (BlockState)((Block)ThermalCore.BLOCKS.get("oil_red_sand")).m_49966_()));
            FeatureUtils.m_254977_(context, APATITE_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(apatite, 9));
            FeatureUtils.m_254977_(context, CINNABAR_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(cinnabar, 5));
            FeatureUtils.m_254977_(context, NITER_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(niter, 7));
            FeatureUtils.m_254977_(context, SULFUR_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(sulfur, 7));
            FeatureUtils.m_254977_(context, LEAD_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(lead, 8));
            FeatureUtils.m_254977_(context, NICKEL_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(nickel, 8));
            FeatureUtils.m_254977_(context, SILVER_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(silver, 8));
            FeatureUtils.m_254977_(context, TIN_ORE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(tin, 8));
            FeatureUtils.m_254977_(context, OIL_SAND, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(oilSand, 24));
            FeatureUtils.m_254977_(context, RUBBERWOOD_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_log"))), (TrunkPlacer)new StraightTrunkPlacer(4, 2, 2), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_leaves"))), (FoliagePlacer)new AcaciaFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0)), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68244_().m_68251_());
            FeatureUtils.m_254977_(context, MEGA_RUBBERWOOD_TREE, (Feature)Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_log"))), (TrunkPlacer)new MegaJungleTrunkPlacer(7, 2, 4), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_leaves"))), (FoliagePlacer)new MegaJungleFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 2), (FeatureSize)new TwoLayersFeatureSize(1, 1, 2)).m_68244_().m_68251_());
            HolderGetter placedFeatureHolderGetter = context.m_255420_(Registries.f_256988_);
            Holder.Reference rubberwood = placedFeatureHolderGetter.m_255043_(Placed.RUBBERWOOD_TREE_CHECKED);
            Holder.Reference megaRubberwood = placedFeatureHolderGetter.m_255043_(Placed.MEGA_RUBBERWOOD_TREE_CHECKED);
            FeatureUtils.m_254977_(context, TREES_RUBBERWOOD, (Feature)Feature.f_65754_, (FeatureConfiguration)new RandomFeatureConfiguration(List.of(new WeightedPlacedFeature((Holder)megaRubberwood, 0.1f)), (Holder)rubberwood));
        }

        private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("thermal", name));
        }
    }
}

