/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ClientPlayerPacket;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_746;

public class ShellStateUpdatePacket
implements ClientPlayerPacket {
    private ShellStateUpdateType type;
    private ShellState shellState;
    private UUID uuid;
    private float progress;
    private class_1767 color;
    private class_2338 pos;

    public ShellStateUpdatePacket(ShellStateUpdateType type, ShellState shellState) {
        this.type = type;
        this.shellState = shellState;
    }

    @Override
    public class_2960 getId() {
        return Sync.locate("packet.shell.state.update");
    }

    @Override
    public void write(class_2540 buffer) {
        if (this.shellState == null && this.type != ShellStateUpdateType.NONE) {
            throw new IllegalStateException();
        }
        buffer.method_10817((Enum)this.type);
        switch (this.type) {
            case ADD: {
                buffer.method_10794(this.shellState.writeNbt(new class_2487()));
                break;
            }
            case REMOVE: {
                buffer.method_10797(this.shellState.getUuid());
                break;
            }
            case UPDATE: {
                buffer.method_10797(this.shellState.getUuid());
                buffer.method_10804((int)(this.shellState.getProgress() * 100.0f));
                buffer.method_10804(this.shellState.getColor() == null ? 127 : this.shellState.getColor().method_7789());
                buffer.method_10807(this.shellState.getPos());
                break;
            }
        }
    }

    @Override
    public void read(class_2540 buffer) {
        this.type = (ShellStateUpdateType)buffer.method_10818(ShellStateUpdateType.class);
        switch (this.type) {
            case ADD: {
                this.shellState = ShellState.fromNbt(buffer.method_10798());
                break;
            }
            case REMOVE: {
                this.uuid = buffer.method_10790();
                break;
            }
            case UPDATE: {
                this.uuid = buffer.method_10790();
                this.progress = class_3532.method_15363((float)((float)buffer.method_10816() / 100.0f), (float)0.0f, (float)1.0f);
                int colorId = buffer.method_10816();
                this.color = colorId < 0 || colorId > 15 ? null : class_1767.method_7791((int)colorId);
                this.pos = buffer.method_10811();
                break;
            }
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void execute(class_310 client, class_746 player, class_634 handler, PacketSender responseSender) {
        Shell shell = (Shell)player;
        if (shell == null) {
            return;
        }
        switch (this.type) {
            case ADD: {
                shell.add(this.shellState);
                break;
            }
            case REMOVE: {
                ShellState state = shell.getShellStateByUuid(this.uuid);
                if (state == null) break;
                shell.remove(state);
                break;
            }
            case UPDATE: {
                ShellState state = shell.getShellStateByUuid(this.uuid);
                if (state == null) break;
                state.setProgress(this.progress);
                state.setColor(this.color);
                state.setPos(this.pos);
                break;
            }
        }
    }
}

