/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.networking;

import dev.kir.sync.Sync;
import dev.kir.sync.api.networking.ServerPlayerPacket;
import dev.kir.sync.api.networking.SynchronizationResponsePacket;
import dev.kir.sync.api.shell.ServerShell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.util.BlockPosUtil;
import dev.kir.sync.util.WorldUtil;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class SynchronizationRequestPacket
implements ServerPlayerPacket {
    private UUID shellUuid;

    public SynchronizationRequestPacket(ShellState shell) {
        this.shellUuid = shell == null ? null : shell.getUuid();
    }

    public SynchronizationRequestPacket(UUID shellUuid) {
        this.shellUuid = shellUuid;
    }

    @Override
    public class_2960 getId() {
        return Sync.locate("packet.shell.synchronization.request");
    }

    @Override
    public void write(class_2540 buffer) {
        if (this.shellUuid == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.method_10797(this.shellUuid);
        }
    }

    @Override
    public void read(class_2540 buffer) {
        this.shellUuid = buffer.readBoolean() ? buffer.method_10790() : null;
    }

    @Override
    public void execute(MinecraftServer server, class_3222 player, class_3244 handler, PacketSender responseSender) {
        ServerShell shell = (ServerShell)player;
        ShellState state = shell.getShellStateByUuid(this.shellUuid);
        class_2338 currentPos = player.method_24515();
        class_1937 currentWorld = player.method_37908();
        class_2960 currentWorldId = WorldUtil.getId(currentWorld);
        class_2350 currentFacing = BlockPosUtil.getHorizontalFacing(currentPos, (class_1922)currentWorld).orElse(player.method_5735().method_10153());
        shell.sync(state).ifLeft(storedState -> {
            Objects.requireNonNull(state);
            class_2960 targetWorldId = state.getWorld();
            class_2338 targetPos = state.getPos();
            class_2350 targetFacing = player.method_5735().method_10153();
            new SynchronizationResponsePacket(currentWorldId, currentPos, currentFacing, targetWorldId, targetPos, targetFacing, (ShellState)storedState).send(responseSender);
        }).ifRight(failureReason -> {
            player.method_7353(failureReason.toText(), false);
            new SynchronizationResponsePacket(currentWorldId, currentPos, currentFacing, currentWorldId, currentPos, currentFacing, null).send(responseSender);
        });
    }
}

