/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.api.shell;

import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateManager;
import dev.kir.sync.api.shell.ShellStateUpdateType;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface Shell
extends ShellStateManager {
    public boolean isClient();

    public UUID getShellOwnerUuid();

    public boolean isArtificial();

    public void changeArtificialStatus(boolean var1);

    @Override
    default public boolean isValidShellOwnerUuid(UUID uuid) {
        return uuid == null || uuid.equals(this.getShellOwnerUuid());
    }

    @Contract(value="null -> false")
    default public boolean canBeApplied(ShellState state) {
        return this.isValidShellState(state) && this.getShellOwnerUuid().equals(state.getOwnerUuid());
    }

    @Nullable
    public ShellState getShellStateByUuid(UUID var1);

    @Override
    @Nullable
    default public ShellState getShellStateByUuid(UUID owner, UUID uuid) {
        return this.isValidShellOwnerUuid(owner) ? this.getShellStateByUuid(uuid) : null;
    }

    public Stream<ShellState> getAvailableShellStates();

    @Override
    default public Stream<ShellState> getAvailableShellStates(UUID owner) {
        return this.isValidShellOwnerUuid(owner) ? this.getAvailableShellStates() : Stream.of(new ShellState[0]);
    }

    public void setAvailableShellStates(Stream<ShellState> var1);

    @Override
    default public void setAvailableShellStates(UUID owner, Stream<ShellState> states) {
        if (this.isValidShellOwnerUuid(owner)) {
            this.setAvailableShellStates(states);
        }
    }

    @Override
    default public Collection<class_3545<ShellStateUpdateType, ShellState>> peekPendingUpdates(UUID owner) {
        return Collections.emptyList();
    }

    @Override
    default public void clearPendingUpdates(UUID owner) {
    }
}

