/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.block;

import dev.kir.sync.block.entity.AbstractShellContainerBlockEntity;
import dev.kir.sync.block.entity.TickableBlockEntity;
import dev.kir.sync.util.ItemUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4732;
import net.minecraft.class_4970;
import net.minecraft.class_5558;

public abstract class AbstractShellContainerBlock
extends class_2237 {
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 OPEN = class_2741.field_12537;
    public static final class_2754<ComparatorOutputType> OUTPUT = class_2754.method_11850((String)"output", ComparatorOutputType.class);
    private static final class_265 SOLID_SHAPE_TOP;
    private static final class_265 SOLID_SHAPE_BOTTOM;
    private static final class_265 NORTH_SHAPE_TOP;
    private static final class_265 NORTH_SHAPE_BOTTOM;
    private static final class_265 SOUTH_SHAPE_TOP;
    private static final class_265 SOUTH_SHAPE_BOTTOM;
    private static final class_265 EAST_SHAPE_TOP;
    private static final class_265 EAST_SHAPE_BOTTOM;
    private static final class_265 WEST_SHAPE_TOP;
    private static final class_265 WEST_SHAPE_BOTTOM;

    protected AbstractShellContainerBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(false))).method_11657(HALF, (Comparable)class_2756.field_12607)).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657(OUTPUT, (Comparable)((Object)ComparatorOutputType.PROGRESS)));
    }

    public static void setOpen(class_2680 state, class_1937 world, class_2338 pos, boolean open) {
        if ((Boolean)state.method_11654((class_2769)OPEN) != open) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            class_2338 secondPos = pos.method_10093(AbstractShellContainerBlock.getDirectionTowardsAnotherPart(state));
            class_2680 secondState = world.method_8320(secondPos);
            if (secondState != null) {
                world.method_8652(secondPos, (class_2680)secondState.method_11657((class_2769)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            }
        }
    }

    public static boolean isOpen(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)OPEN);
    }

    public static boolean isBottom(class_2680 state) {
        class_2756 half = (class_2756)state.method_11654(HALF);
        return half == class_2756.field_12607;
    }

    public static class_4732.class_4733 getShellContainerHalf(class_2680 state) {
        class_2756 part = (class_2756)state.method_11654(HALF);
        return part == class_2756.field_12607 ? class_4732.class_4733.field_21784 : class_4732.class_4733.field_21785;
    }

    public static class_2350 getDirectionTowardsAnotherPart(class_2680 state) {
        return AbstractShellContainerBlock.isBottom(state) ? class_2350.field_11036 : class_2350.field_11033;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        if (direction.method_10166() == class_2350.class_2351.field_11052 && doubleBlockHalf == class_2756.field_12607 == (direction == class_2350.field_11036)) {
            return neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != doubleBlockHalf ? (class_2680)state.method_11657((class_2769)FACING, (Comparable)((class_2350)neighborState.method_11654((class_2769)FACING))) : class_2246.field_10124.method_9564();
        }
        return doubleBlockHalf == class_2756.field_12607 && direction == class_2350.field_11033 && !state.method_26184((class_4538)world, pos) ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        if (class_1937.method_25953((class_2338)blockPos) && world.method_8320(blockPos.method_10084()).method_26166(ctx)) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042())).method_11657(HALF, (Comparable)class_2756.field_12607);
        }
        return null;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        world.method_8652(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        super.method_9548(state, world, pos, entity);
        if (!world.field_9236 && entity instanceof class_1657 && AbstractShellContainerBlock.isBottom(state)) {
            AbstractShellContainerBlock.setOpen(state, world, pos, true);
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2680 blockState;
        class_2338 bottomPos;
        boolean bottom = AbstractShellContainerBlock.isBottom(state);
        class_2338 class_23382 = bottomPos = bottom ? pos : pos.method_10074();
        if (!world.field_9236 && player.method_7337() && !bottom && (blockState = world.method_8320(bottomPos)).method_26204() == state.method_26204() && blockState.method_11654(HALF) == class_2756.field_12607) {
            world.method_8652(bottomPos, class_2246.field_10124.method_9564(), 35);
            world.method_8444(player, 2001, bottomPos, class_2248.method_9507((class_2680)blockState));
        }
        super.method_9576(world, pos, state, player);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (!state.method_27852(newState.method_26204())) {
            class_2586 class_25862;
            if (AbstractShellContainerBlock.isBottom(state) && (class_25862 = world.method_8321(pos)) instanceof AbstractShellContainerBlockEntity) {
                AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)class_25862;
                shellContainer.onBreak(world, pos);
            }
            world.method_8544(pos);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (ItemUtil.isWrench(player.method_5998(hand))) {
            if (!world.field_9236) {
                world.method_8652(pos, (class_2680)state.method_28493(OUTPUT), 10);
                world.method_8455(pos, state.method_26204());
            }
            return class_1269.field_5812;
        }
        if (!AbstractShellContainerBlock.isBottom(state)) {
            pos = pos.method_10074();
            state = world.method_8320(pos);
        }
        if ((class_25862 = world.method_8321(pos)) instanceof AbstractShellContainerBlockEntity) {
            AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)class_25862;
            return shellContainer.onUse(world, pos, player, hand);
        }
        return super.method_9534(state, world, pos, player, hand, hit);
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        int n;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof AbstractShellContainerBlockEntity) {
            AbstractShellContainerBlockEntity shellContainer = (AbstractShellContainerBlockEntity)class_25862;
            n = state.method_11654(OUTPUT) == ComparatorOutputType.PROGRESS ? shellContainer.getProgressComparatorOutput() : shellContainer.getInventoryComparatorOutput();
        } else {
            n = 0;
        }
        return n;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    @Environment(value=EnvType.CLIENT)
    public long method_9535(class_2680 state, class_2338 pos) {
        return class_3532.method_15371((int)pos.method_10263(), (int)pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)pos.method_10260());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{HALF, FACING, OPEN, OUTPUT});
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (!AbstractShellContainerBlock.isBottom(state)) {
            return null;
        }
        return world.field_9236 ? TickableBlockEntity::clientTicker : TickableBlockEntity::serverTicker;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        boolean isBottom = AbstractShellContainerBlock.isBottom(state);
        if (!AbstractShellContainerBlock.isOpen(state)) {
            return isBottom ? SOLID_SHAPE_BOTTOM : SOLID_SHAPE_TOP;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return switch (direction) {
            case class_2350.field_11043 -> {
                if (isBottom) {
                    yield NORTH_SHAPE_BOTTOM;
                }
                yield NORTH_SHAPE_TOP;
            }
            case class_2350.field_11035 -> {
                if (isBottom) {
                    yield SOUTH_SHAPE_BOTTOM;
                }
                yield SOUTH_SHAPE_TOP;
            }
            case class_2350.field_11034 -> {
                if (isBottom) {
                    yield EAST_SHAPE_BOTTOM;
                }
                yield EAST_SHAPE_TOP;
            }
            case class_2350.field_11039 -> {
                if (isBottom) {
                    yield WEST_SHAPE_BOTTOM;
                }
                yield WEST_SHAPE_TOP;
            }
            default -> throw new IllegalArgumentException();
        };
    }

    static {
        class_265 ROOF = class_2248.method_9541((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 FLOOR = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
        class_265 NORTH_WALL = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
        class_265 SOUTH_WALL = class_2248.method_9541((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 EAST_WALL = class_2248.method_9541((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        class_265 WEST_WALL = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
        class_265 NORTH_SHAPE = class_259.method_17786((class_265)NORTH_WALL, (class_265[])new class_265[]{EAST_WALL, WEST_WALL}).method_1097();
        class_265 SOUTH_SHAPE = class_259.method_17786((class_265)SOUTH_WALL, (class_265[])new class_265[]{EAST_WALL, WEST_WALL}).method_1097();
        class_265 EAST_SHAPE = class_259.method_17786((class_265)NORTH_WALL, (class_265[])new class_265[]{SOUTH_WALL, EAST_WALL}).method_1097();
        class_265 WEST_SHAPE = class_259.method_17786((class_265)NORTH_WALL, (class_265[])new class_265[]{SOUTH_WALL, WEST_WALL}).method_1097();
        SOLID_SHAPE_TOP = class_259.method_17786((class_265)NORTH_WALL, (class_265[])new class_265[]{SOUTH_WALL, EAST_WALL, WEST_WALL, ROOF}).method_1097();
        SOLID_SHAPE_BOTTOM = class_259.method_17786((class_265)NORTH_WALL, (class_265[])new class_265[]{SOUTH_WALL, EAST_WALL, WEST_WALL, FLOOR}).method_1097();
        NORTH_SHAPE_TOP = class_259.method_1084((class_265)NORTH_SHAPE, (class_265)ROOF).method_1097();
        NORTH_SHAPE_BOTTOM = class_259.method_1084((class_265)NORTH_SHAPE, (class_265)FLOOR).method_1097();
        SOUTH_SHAPE_TOP = class_259.method_1084((class_265)SOUTH_SHAPE, (class_265)ROOF).method_1097();
        SOUTH_SHAPE_BOTTOM = class_259.method_1084((class_265)SOUTH_SHAPE, (class_265)FLOOR).method_1097();
        EAST_SHAPE_TOP = class_259.method_1084((class_265)EAST_SHAPE, (class_265)ROOF).method_1097();
        EAST_SHAPE_BOTTOM = class_259.method_1084((class_265)EAST_SHAPE, (class_265)FLOOR).method_1097();
        WEST_SHAPE_TOP = class_259.method_1084((class_265)WEST_SHAPE, (class_265)ROOF).method_1097();
        WEST_SHAPE_BOTTOM = class_259.method_1084((class_265)WEST_SHAPE, (class_265)FLOOR).method_1097();
    }

    public static enum ComparatorOutputType implements class_3542
    {
        PROGRESS,
        INVENTORY;


        public String method_15434() {
            return this == PROGRESS ? "progress" : "inventory";
        }

        public String toString() {
            return this.method_15434();
        }
    }
}

