/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import dev.kir.sync.client.gui.widget.AbstractWidget;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class PageDisplayWidget<TKey, UData>
extends AbstractWidget {
    private static final int DEFAULT_TEXT_COLOR = ColorUtil.fromDyeColor(class_1767.field_7952);
    private static final int DEFAULT_BACKGROUND_COLOR = ColorUtil.fromDyeColor(class_1767.field_7963, 0.6f);
    private static final float DEFAULT_SCALE = 1.0f;
    private static final float DEFAULT_STEP = 0.09817477f;
    private final float cX;
    private final float cY;
    private final float scale;
    private final float step;
    private final int textColor;
    private final float[] backgroundColor;
    private final Map<TKey, List<UData>> data;
    private final List<TKey> keys;
    private final Function<TKey, class_2561> keyTransformer;
    private final int entriesPerPage;
    private final BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange;
    private int selectedKeyIndex;
    private int selectedPageIndex;
    private class_2561 selectedKeyAsText;
    private int selectedSectionPageCount;
    private boolean focused;

    public PageDisplayWidget(float cX, float cY, Stream<UData> data, Function<UData, TKey> keySelector, Function<TKey, class_2561> keyTransformer, TKey defaultKey, int entriesPerPage, BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange) {
        this(cX, cY, 1.0f, 0.09817477f, DEFAULT_TEXT_COLOR, DEFAULT_BACKGROUND_COLOR, data, keySelector, keyTransformer, defaultKey, entriesPerPage, onSelectionChange);
    }

    public PageDisplayWidget(float cX, float cY, float scale, Stream<UData> data, Function<UData, TKey> keySelector, Function<TKey, class_2561> keyTransformer, TKey defaultKey, int entriesPerPage, BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange) {
        this(cX, cY, scale, 0.09817477f, DEFAULT_TEXT_COLOR, DEFAULT_BACKGROUND_COLOR, data, keySelector, keyTransformer, defaultKey, entriesPerPage, onSelectionChange);
    }

    public PageDisplayWidget(float cX, float cY, int textColor, int backgroundColor, Stream<UData> data, Function<UData, TKey> keySelector, Function<TKey, class_2561> keyTransformer, TKey defaultKey, int entriesPerPage, BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange) {
        this(cX, cY, 1.0f, 0.09817477f, textColor, backgroundColor, data, keySelector, keyTransformer, defaultKey, entriesPerPage, onSelectionChange);
    }

    public PageDisplayWidget(float cX, float cY, float scale, int textColor, int backgroundColor, Stream<UData> data, Function<UData, TKey> keySelector, Function<TKey, class_2561> keyTransformer, TKey defaultKey, int entriesPerPage, BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange) {
        this(cX, cY, scale, 0.09817477f, textColor, backgroundColor, data, keySelector, keyTransformer, defaultKey, entriesPerPage, onSelectionChange);
    }

    public PageDisplayWidget(float cX, float cY, float scale, float step, int textColor, int backgroundColor, Stream<UData> data, Function<UData, TKey> keySelector, Function<TKey, class_2561> keyTransformer, TKey defaultKey, int entriesPerPage, BiConsumer<PageDisplayWidget<TKey, UData>, Page> onSelectionChange) {
        this.cX = cX;
        this.cY = cY;
        this.scale = scale;
        this.step = step;
        this.textColor = textColor;
        this.backgroundColor = ColorUtil.toRGBA(backgroundColor);
        this.data = data.collect(Collectors.groupingBy(keySelector, HashMap::new, Collectors.toList()));
        this.keys = new ArrayList<TKey>(this.data.keySet());
        this.keyTransformer = keyTransformer;
        this.entriesPerPage = entriesPerPage;
        this.onSelectionChange = onSelectionChange;
        Object object = defaultKey = defaultKey == null ? this.keys.stream().findFirst().orElseThrow() : defaultKey;
        if (!this.data.containsKey(defaultKey)) {
            this.data.put(defaultKey, List.of());
            this.keys.add(defaultKey);
        }
        this.select(defaultKey, 0);
    }

    public void select(int section, int page) {
        section = class_3532.method_15340((int)((section + this.keys.size()) % this.keys.size()), (int)0, (int)(this.keys.size() - 1));
        TKey key = this.keys.get(section);
        int pages = Math.max(1, (int)Math.ceil((double)this.data.get(key).size() / (double)this.entriesPerPage));
        page = class_3532.method_15340((int)((page + pages) % pages), (int)0, (int)(pages - 1));
        List content = this.data.get(key).stream().skip((long)this.entriesPerPage * (long)page).limit(this.entriesPerPage).collect(Collectors.toList());
        this.selectedKeyIndex = section;
        this.selectedPageIndex = page;
        this.selectedKeyAsText = this.keyTransformer.apply(key);
        this.selectedSectionPageCount = pages;
        if (this.onSelectionChange != null) {
            this.onSelectionChange.accept(this, new Page(key, section, page, pages, content));
        }
    }

    public void select(TKey sectionKey, int page) {
        this.select(this.keys.indexOf(sectionKey), page);
    }

    public boolean hasMoreSections() {
        return this.keys.size() > 1;
    }

    public boolean hasMorePages() {
        return this.selectedSectionPageCount > 1;
    }

    public void nextSection() {
        this.select(this.selectedKeyIndex + 1, 0);
    }

    public void previousSection() {
        this.select(this.selectedKeyIndex - 1, 0);
    }

    public void nextPage() {
        this.select(this.selectedKeyIndex, this.selectedPageIndex + 1);
    }

    public void previousPage() {
        this.select(this.selectedKeyIndex, this.selectedPageIndex - 1);
    }

    public void moveSelection(int dSection, int dPage) {
        this.select(this.selectedKeyIndex + dSection, this.selectedPageIndex + dPage);
    }

    @Override
    protected void renderContent(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (this.hasMorePages()) {
            this.renderTitleAndPagination(drawContext);
        } else {
            this.renderTitle(drawContext);
        }
    }

    private void renderTitle(class_332 drawContext) {
        RenderSystemUtil.drawCenteredText(drawContext, this.selectedKeyAsText, this.cX, this.cY, this.scale, this.textColor, true);
    }

    private void renderTitleAndPagination(class_332 drawContext) {
        String paginationText = String.format("%s / %s", this.selectedPageIndex + 1, this.selectedSectionPageCount);
        class_327 textRenderer = RenderSystemUtil.getTextRenderer();
        float paginationTextScale = 0.5f;
        Objects.requireNonNull(textRenderer);
        float titleHeight = 9.0f * this.scale;
        float spacing = titleHeight * 5.0f / 6.0f;
        float paginationTextWidth = (float)textRenderer.method_1727(paginationText) * this.scale * paginationTextScale;
        float paginationBoxWidth = Math.max(titleHeight * 2.0f, paginationTextWidth);
        float height = 2.0f * titleHeight + spacing;
        float top = this.cY - height / 2.0f;
        float boxTop = top + titleHeight + spacing - titleHeight * paginationTextScale * 0.125f;
        float boxLeft = this.cX - paginationBoxWidth / 2.0f;
        RenderSystemUtil.drawRectangle(drawContext.method_51448(), boxLeft, boxTop, paginationBoxWidth / this.scale, titleHeight / this.scale, titleHeight * 0.25f / this.scale, this.scale, 0.0f, this.step, this.backgroundColor[0], this.backgroundColor[1], this.backgroundColor[2], this.backgroundColor[3]);
        RenderSystemUtil.drawCenteredText(drawContext, this.selectedKeyAsText, this.cX, top + titleHeight, this.scale, this.textColor, true);
        RenderSystemUtil.drawCenteredText(drawContext, class_2561.method_30163((String)paginationText), this.cX, top + 1.5f * titleHeight + spacing, this.scale * paginationTextScale, this.textColor, false);
    }

    public void method_25365(boolean focused) {
        this.focused = focused;
    }

    public boolean method_25370() {
        return this.focused;
    }

    public class Page {
        public final TKey key;
        public final int sectionIndex;
        public final int pageIndex;
        public final int pageCount;
        public final List<UData> content;

        private Page(TKey key, int sectionIndex, int pageIndex, int pageCount, List<UData> content) {
            this.key = key;
            this.sectionIndex = sectionIndex;
            this.pageIndex = pageIndex;
            this.pageCount = pageCount;
            this.content = content;
        }
    }
}

