/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.kir.sync.api.event.PlayerSyncEvents;
import dev.kir.sync.api.shell.ClientShell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.client.gl.MSAAFramebuffer;
import dev.kir.sync.client.gui.widget.AbstractWidget;
import dev.kir.sync.client.render.MatrixStackStorage;
import dev.kir.sync.entity.ShellEntity;
import dev.kir.sync.util.client.render.ColorUtil;
import dev.kir.sync.util.client.render.RenderSystemUtil;
import java.util.Objects;
import java.util.function.BiPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class ShellSelectorButtonWidget
extends AbstractWidget {
    private static final class_1767 DEFAULT_COLOR = class_1767.field_7963;
    private static final float DEFAULT_ALPHA = 0.6f;
    private static final float DEFAULT_HOVERED_ALPHA = 0.8f;
    private static final float DEFAULT_PRESSED_ALPHA = 1.0f;
    private static final double DEFAULT_STEP = 0.02454369328916073;
    private final double cX;
    private final double cY;
    private final double majorR;
    private final double minorR;
    private final double diffR;
    private final double minorRBorder;
    private final double from;
    private final double to;
    private final double step;
    private final class_1767 color;
    private final float alpha;
    private final float hoveredAlpha;
    private final float pressedAlpha;
    private final BiPredicate<Double, Double> belongsToSectorPredicate;
    public ShellState shell;

    public ShellSelectorButtonWidget(double cX, double cY, double majorR, double minorR, double borderWidth, double from, double to) {
        this(cX, cY, majorR, minorR, borderWidth, from, to, 0.02454369328916073, DEFAULT_COLOR, 0.6f, 0.8f, 1.0f);
    }

    public ShellSelectorButtonWidget(double cX, double cY, double majorR, double minorR, double borderWidth, double from, double to, class_1767 color) {
        this(cX, cY, majorR, minorR, borderWidth, from, to, 0.02454369328916073, color, 0.6f, 0.8f, 1.0f);
    }

    public ShellSelectorButtonWidget(double cX, double cY, double majorR, double minorR, double borderWidth, double from, double to, class_1767 color, float alpha, float hoveredAlpha, float pressedAlpha) {
        this(cX, cY, majorR, minorR, borderWidth, from, to, 0.02454369328916073, color, alpha, hoveredAlpha, pressedAlpha);
    }

    public ShellSelectorButtonWidget(double cX, double cY, double majorR, double minorR, double borderWidth, double from, double to, double step, class_1767 color, float alpha, float hoveredAlpha, float pressedAlpha) {
        boolean isFullCircle;
        boolean bl = isFullCircle = Math.abs(6.2831854820251465 - to + from) < step;
        if (isFullCircle) {
            double tmp = from;
            from = -to;
            to = -tmp;
        }
        this.cX = cX;
        this.cY = cY;
        this.majorR = majorR;
        this.minorR = minorR;
        this.diffR = majorR - minorR;
        this.minorRBorder = majorR - borderWidth;
        this.from = from;
        this.to = to;
        this.step = step;
        this.color = color;
        this.alpha = alpha;
        this.hoveredAlpha = hoveredAlpha;
        this.pressedAlpha = pressedAlpha;
        double x0 = majorR * Math.cos(from) + cX;
        double y0 = majorR * Math.sin(from) + cY;
        double x1 = majorR * Math.cos(to) + cX;
        double y1 = majorR * Math.sin(to) + cY;
        double a0 = (y0 - cY) / (x0 - cX);
        double b0 = -a0 * cX + cY;
        double a1 = (y1 - cY) / (x1 - cX);
        double b1 = -a1 * cX + cY;
        this.belongsToSectorPredicate = isFullCircle ? (x, y) -> true : (from < 1.5707963705062866 && to > 1.5707963705062866 ? (x, y) -> ShellSelectorButtonWidget.liesOnOrAboveLine(x, y, a0, b0) && ShellSelectorButtonWidget.liesOnOrAboveLine(x, y, a1, b1) : (from < 4.71238899230957 && to > 4.71238899230957 ? (x, y) -> ShellSelectorButtonWidget.liesOnOrBelowLine(x, y, a0, b0) && ShellSelectorButtonWidget.liesOnOrBelowLine(x, y, a1, b1) : (y1 > y0 ? (x, y) -> ShellSelectorButtonWidget.liesOnOrAboveLine(x, y, a0, b0) && ShellSelectorButtonWidget.liesOnOrBelowLine(x, y, a1, b1) : (x, y) -> ShellSelectorButtonWidget.liesOnOrBelowLine(x, y, a0, b0) && ShellSelectorButtonWidget.liesOnOrAboveLine(x, y, a1, b1))));
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.shell != null && ShellSelectorButtonWidget.liesOnCircle(mouseX, mouseY, this.cX, this.cY, this.majorR) && !ShellSelectorButtonWidget.liesOnCircle(mouseX, mouseY, this.cX, this.cY, this.minorR) && this.belongsToSectorPredicate.test(mouseX, mouseY);
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    @Override
    protected void renderContent(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.renderSector(drawContext.method_51448());
        if (this.shell != null) {
            if (this.shell.getProgress() < 0.75f) {
                this.renderShellAndProgress(drawContext);
            } else {
                MSAAFramebuffer.renderAfterUsage(() -> this.renderShellAndProgress(drawContext));
            }
        }
    }

    @Override
    protected void onMouseClick(double mouseX, double mouseY, int button) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || this.shell == null || this.shell.getProgress() < 1.0f) {
            return;
        }
        PlayerSyncEvents.SyncFailureReason failureReason = ((ClientShell)client.field_1724).beginSync(this.shell);
        if (failureReason != null) {
            if (client.field_1755 != null) {
                client.field_1755.method_25419();
            }
            client.field_1724.method_7353(failureReason.toText(), true);
        }
    }

    private void renderSector(class_4587 matrices) {
        float alpha = this.isPressed() ? this.pressedAlpha : (this.isHovered() ? this.hoveredAlpha : this.alpha);
        class_1767 borderColor = this.shell == null ? null : this.shell.getColor();
        class_1767 color = borderColor != null && (this.isHovered() || this.isPressed()) ? borderColor : this.color;
        float[] rgb = color.method_7787();
        RenderSystemUtil.drawAnnulusSector(matrices, this.cX, this.cY, this.majorR, this.minorR, this.from, this.to, this.step, rgb[0], rgb[1], rgb[2], alpha);
        if (borderColor != null) {
            rgb = borderColor.method_7787();
            RenderSystemUtil.drawAnnulusSector(matrices, this.cX, this.cY, this.majorR, this.minorRBorder, this.from, this.to, this.step, rgb[0], rgb[1], rgb[2], 1.0f);
        }
    }

    private void renderShellAndProgress(class_332 drawContext) {
        this.renderShell(drawContext);
        if (this.shell.getProgress() < 1.0f) {
            this.renderProgress(drawContext);
        }
    }

    private void renderShell(class_332 drawContext) {
        double SHELL_WIDTH_HALF = 0.26f;
        double SHELL_HEIGHT_HALF = 0.35f;
        float SHELL_SCALE = 0.365f;
        ShellEntity shellEntity = this.shell.asEntity();
        shellEntity.pitchProgress = 0.0f;
        shellEntity.isActive = this.shell.getProgress() >= 1.0f;
        double r = this.minorR + this.diffR / 2.0;
        double tAngle = (this.to + this.from) / 2.0;
        double shellCX = r * Math.cos(tAngle) + this.cX;
        double shellCY = r * Math.sin(tAngle) + this.cY;
        double tX = shellCX - this.diffR * (double)0.26f;
        double tY = shellCY + this.diffR * (double)0.35f;
        float scale = (float)this.diffR * 0.365f;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22904(tX, tY, this.majorR);
        matrices.method_22905(scale, -scale, 1.0f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(15.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(40.0f));
        RenderSystem.setupGui3DDiffuseLighting((Vector3f)new Vector3f((float)this.cX * 2.0f, (float)this.cY * 2.0f, -1.0f), (Vector3f)new Vector3f(0.0f, 0.0f, 1.0f));
        MatrixStackStorage.saveModelMatrixStack(matrices);
        class_4597.class_4598 immediate = RenderSystemUtil.getEntityVertexConsumerProvider();
        class_898 renderDispatcher = class_310.method_1551().method_1561();
        renderDispatcher.method_3954((class_1297)shellEntity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (class_4597)immediate, 0xF000F0);
        immediate.method_22993();
        matrices.method_22909();
    }

    private void renderProgress(class_332 drawContext) {
        float FONT_SCALE = 0.15f;
        float BOX_SCALE = 1.6f;
        class_327 textRenderer = RenderSystemUtil.getTextRenderer();
        double r = this.minorR + this.diffR / 2.0;
        double tAngle = (this.to + this.from) / 2.0;
        float shellCX = (float)(r * Math.cos(tAngle) + this.cX);
        float shellCY = (float)(r * Math.sin(tAngle) + this.cY);
        float fontHeight = (float)this.diffR * 0.15f;
        Objects.requireNonNull(textRenderer);
        float fontScale = fontHeight / 9.0f;
        int progress = (int)Math.floor(this.shell.getProgress() * 100.0f);
        class_2561 progressText = class_2561.method_30163((String)String.format("%s%%", progress));
        float boxHeight = fontHeight * 1.6f;
        float progressTextWidth = (float)textRenderer.method_27525((class_5348)progressText) * fontScale;
        float progressBoxWidth = Math.max(boxHeight * 2.0f, progressTextWidth);
        float f = shellCY - boxHeight / 2.0f;
        Objects.requireNonNull(textRenderer);
        float boxTop = f - 9.0f * fontScale * 0.125f;
        float boxLeft = shellCX - progressBoxWidth / 2.0f;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.0, 0.0, this.majorR * 2.0);
        RenderSystemUtil.drawRectangle(matrices, boxLeft, boxTop, progressBoxWidth, boxHeight, boxHeight * 0.25f, 1.0f, 0.0f, (float)this.step, 0.0f, 0.0f, 0.0f, 0.8f);
        RenderSystemUtil.drawCenteredText(drawContext, progressText, shellCX, shellCY, fontScale, ColorUtil.fromDyeColor(class_1767.field_7952), true);
        matrices.method_22909();
    }

    @Override
    protected class_2561 getWidgetDescription() {
        if (this.shell == null) {
            return null;
        }
        class_2338 pos = this.shell.getPos();
        return class_2561.method_30163((String)String.format("%s, %s, %s", pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    private static boolean liesOnCircle(double x, double y, double cX, double cY, double r) {
        return class_3532.method_33723((double)(cX - x)) + class_3532.method_33723((double)(cY - y)) <= r * r;
    }

    private static boolean liesOnOrAboveLine(double x, double y, double a, double b) {
        return y >= a * x + b;
    }

    private static boolean liesOnOrBelowLine(double x, double y, double a, double b) {
        return y <= a * x + b;
    }
}

