/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.model;

import dev.kir.sync.client.model.VoxelModel;
import dev.kir.sync.client.render.CustomRenderLayer;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4592;

@Environment(value=EnvType.CLIENT)
public class ShellModel<T extends class_4592<?>>
extends class_3879 {
    public final T parentModel;
    private float buildProgress;
    private final VoxelModel voxelModel;

    public ShellModel(T parentModel) {
        this(parentModel, new Random());
    }

    public ShellModel(T parentModel, Random random) {
        super(null);
        this.parentModel = parentModel;
        this.buildProgress = 0.0f;
        this.voxelModel = VoxelModel.fromModel(parentModel, random);
    }

    public void setBuildProgress(float buildProgress) {
        this.buildProgress = buildProgress;
        this.voxelModel.completeness = buildProgress / 0.75f;
    }

    public void setDestructionProgress(float destructionProgress) {
        this.voxelModel.destructionProgress = destructionProgress;
    }

    public class_1921 method_23500(class_2960 textureId) {
        if (this.isBeingPrinted() || this.isBeingDestroyed()) {
            return this.voxelModel.method_23500(textureId);
        }
        if (this.isBeingPainted()) {
            float paintingProgress = (this.buildProgress - 0.75f) / 0.25f;
            float cutoutY = this.voxelModel.pivotY + this.voxelModel.sizeY * (1.0f - paintingProgress);
            return CustomRenderLayer.getEntityTranslucentPartiallyTextured(textureId, cutoutY);
        }
        return class_1921.method_23580((class_2960)textureId);
    }

    public void method_2828(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        VoxelModel target = this.isBeingPrinted() || this.isBeingDestroyed() ? this.voxelModel : this.parentModel;
        target.method_2828(matrices, vertices, light, overlay, red, green, blue, alpha);
    }

    private boolean isBeingPrinted() {
        return this.buildProgress >= 0.0f && this.buildProgress < 0.75f;
    }

    private boolean isBeingPainted() {
        return this.buildProgress >= 0.75f && this.buildProgress < 1.0f;
    }

    private boolean isBeingDestroyed() {
        return this.voxelModel.destructionProgress > 0.0f;
    }
}

