/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.client.texture;

import dev.kir.sync.client.texture.TextureGenerator;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_3545;
import net.minecraft.class_5253;

@Environment(value=EnvType.CLIENT)
public final class TextureGenerators {
    public static final TextureGenerator PlayerEntityPartiallyTexturedTextureGenerator = new PlayerEntityPartiallyTexturedTextureGenerator();

    private static class PlayerEntityPartiallyTexturedTextureGenerator
    implements TextureGenerator {
        private static final int TEXTURE_SIZE = 64;
        private static final int BLOCKS = 32;
        private static final int TRANSPARENT = class_5253.class_8045.method_48344((int)0, (int)0, (int)0, (int)0);
        private static final int WHITE = class_5253.class_8045.method_48344((int)255, (int)255, (int)255, (int)255);
        private static final class_3545<class_3545<Integer, Integer>, class_3545<class_3545<Integer, Integer>, class_3545<Integer, Integer>>>[] REGIONS = new class_3545[]{new class_3545((Object)new class_3545((Object)0, (Object)0), (Object)new class_3545((Object)new class_3545((Object)8, (Object)0), (Object)new class_3545((Object)8, (Object)8))), new class_3545((Object)new class_3545((Object)1, (Object)8), (Object)new class_3545((Object)new class_3545((Object)0, (Object)8), (Object)new class_3545((Object)32, (Object)8))), new class_3545((Object)new class_3545((Object)9, (Object)9), (Object)new class_3545((Object)new class_3545((Object)16, (Object)0), (Object)new class_3545((Object)8, (Object)8))), new class_3545((Object)new class_3545((Object)9, (Object)9), (Object)new class_3545((Object)new class_3545((Object)20, (Object)16), (Object)new class_3545((Object)8, (Object)4))), new class_3545((Object)new class_3545((Object)9, (Object)9), (Object)new class_3545((Object)new class_3545((Object)44, (Object)16), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)9, (Object)9), (Object)new class_3545((Object)new class_3545((Object)36, (Object)48), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)9, (Object)20), (Object)new class_3545((Object)new class_3545((Object)16, (Object)20), (Object)new class_3545((Object)24, (Object)12))), new class_3545((Object)new class_3545((Object)9, (Object)20), (Object)new class_3545((Object)new class_3545((Object)40, (Object)20), (Object)new class_3545((Object)16, (Object)12))), new class_3545((Object)new class_3545((Object)9, (Object)20), (Object)new class_3545((Object)new class_3545((Object)32, (Object)52), (Object)new class_3545((Object)16, (Object)12))), new class_3545((Object)new class_3545((Object)21, (Object)21), (Object)new class_3545((Object)new class_3545((Object)28, (Object)16), (Object)new class_3545((Object)8, (Object)4))), new class_3545((Object)new class_3545((Object)21, (Object)21), (Object)new class_3545((Object)new class_3545((Object)48, (Object)16), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)21, (Object)21), (Object)new class_3545((Object)new class_3545((Object)40, (Object)48), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)21, (Object)21), (Object)new class_3545((Object)new class_3545((Object)4, (Object)16), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)21, (Object)21), (Object)new class_3545((Object)new class_3545((Object)20, (Object)48), (Object)new class_3545((Object)4, (Object)4))), new class_3545((Object)new class_3545((Object)21, (Object)32), (Object)new class_3545((Object)new class_3545((Object)0, (Object)20), (Object)new class_3545((Object)16, (Object)12))), new class_3545((Object)new class_3545((Object)21, (Object)32), (Object)new class_3545((Object)new class_3545((Object)16, (Object)52), (Object)new class_3545((Object)16, (Object)12)))};
        private final int multiplier;

        public PlayerEntityPartiallyTexturedTextureGenerator() {
            this(1);
        }

        public PlayerEntityPartiallyTexturedTextureGenerator(int multiplier) {
            this.multiplier = multiplier;
        }

        @Override
        public Stream<class_1044> generateTextures() {
            int textureSize = 64 * this.multiplier;
            int textureCount = 32 * this.multiplier;
            ArrayList<class_1044> textures = new ArrayList<class_1044>(textureCount + 1);
            for (int i = 0; i <= textureCount; ++i) {
                textures.add(dev.kir.sync.client.texture.TextureGenerators$PlayerEntityPartiallyTexturedTextureGenerator.generateTexture(textureSize, (float)i / (float)textureCount));
            }
            return textures.stream();
        }

        private static class_1044 generateTexture(int textureSize, float emptiness) {
            class_3545 limit;
            class_1011 img = new class_1011(textureSize, textureSize, false);
            int multiplier = textureSize / 64;
            float lastBlock = (float)(32 * multiplier) * emptiness;
            img.method_4326(0, 0, textureSize, textureSize, TRANSPARENT);
            for (int i = REGIONS.length - 1; i >= 0 && !(lastBlock > (float)((Integer)(limit = (class_3545)REGIONS[i].method_15442()).method_15441()).intValue()); --i) {
                class_3545 pos = (class_3545)((class_3545)REGIONS[i].method_15441()).method_15442();
                class_3545 size = (class_3545)((class_3545)REGIONS[i].method_15441()).method_15441();
                if (lastBlock > (float)((Integer)limit.method_15442()).intValue()) {
                    int oldY = (Integer)pos.method_15441() * multiplier;
                    int y = (int)(((float)((Integer)pos.method_15441()).intValue() + lastBlock - (float)((Integer)limit.method_15442()).intValue()) * (float)multiplier);
                    int height = (Integer)size.method_15441() * multiplier - (y - oldY);
                    img.method_4326((Integer)pos.method_15442() * multiplier, y, (Integer)size.method_15442() * multiplier, height, WHITE);
                    continue;
                }
                img.method_4326((Integer)pos.method_15442() * multiplier, (Integer)pos.method_15441() * multiplier, (Integer)size.method_15442() * multiplier, (Integer)size.method_15441() * multiplier, WHITE);
            }
            return new class_1043(img);
        }
    }
}

