/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kir.sync.api.shell.Shell;
import dev.kir.sync.api.shell.ShellState;
import dev.kir.sync.api.shell.ShellStateContainer;
import dev.kir.sync.command.Command;
import dev.kir.sync.util.WorldUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class GhostShellsCommand
implements Command {
    private static final SimpleCommandExceptionType INVALID_ACTION_TYPE = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"command.sync.ghostshells.invalid_action"));

    @Override
    public String getName() {
        return "ghostshells";
    }

    @Override
    public boolean hasPermissions(class_2168 commandSource) {
        int OP_LEVEL = 2;
        return commandSource.method_9259(2) || commandSource.method_9211().method_3724();
    }

    @Override
    public void build(ArgumentBuilder<class_2168, ?> builder) {
        builder.then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((a, b) -> class_2172.method_9265(Set.of("sync", "remove", "repair"), (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(GhostShellsCommand::execute)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(GhostShellsCommand::execute))));
    }

    private static int execute(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2338 pos;
        boolean repair;
        String type;
        boolean canSkip = switch (type = StringArgumentType.getString(context, (String)"type")) {
            case "sync" -> {
                repair = true;
                yield true;
            }
            case "remove" -> {
                repair = false;
                yield true;
            }
            case "repair" -> {
                repair = true;
                yield false;
            }
            default -> throw INVALID_ACTION_TYPE.create();
        };
        Consumer<class_2561> logger = x -> ((class_2168)context.getSource()).method_9226(() -> x, false);
        Collection players = class_2186.method_9312(context, (String)"target");
        try {
            pos = class_2262.method_48299(context, (String)"pos");
        }
        catch (IllegalArgumentException e) {
            pos = null;
        }
        if (pos == null) {
            for (class_3222 player : players) {
                GhostShellsCommand.updateShells(player, repair, canSkip, logger);
            }
        } else {
            class_2338 finalPos = pos;
            for (class_3222 player : players) {
                ShellState shellState = ((Shell)player).getAvailableShellStates().filter(x -> x.getPos().equals((Object)finalPos)).findAny().orElse(null);
                if (shellState == null) {
                    logger.accept((class_2561)class_2561.method_43469((String)"command.sync.ghostshells.not_found", (Object[])new Object[]{player.method_5477().getString(), pos.method_23854()}));
                    continue;
                }
                GhostShellsCommand.updateShell(player, shellState, repair, canSkip, logger);
            }
        }
        return 1;
    }

    private static void updateShells(class_3222 player, boolean shouldRepair, boolean skipOnFailure, Consumer<class_2561> logger) {
        for (ShellState shellState : ((Shell)player).getAvailableShellStates()::iterator) {
            shellState.setProgress(100.0f);
            GhostShellsCommand.updateShell(player, shellState, shouldRepair, skipOnFailure, logger);
        }
    }

    private static void updateShell(class_3222 player, ShellState shellState, boolean shouldRepair, boolean skipOnFailure, Consumer<class_2561> logger) {
        if (GhostShellsCommand.shellExists(player.field_13995, shellState)) {
            return;
        }
        if (shouldRepair) {
            if (GhostShellsCommand.tryRepair(player.field_13995, shellState)) {
                logger.accept((class_2561)class_2561.method_43469((String)"command.sync.ghostshells.repaired", (Object[])new Object[]{player.method_5477().getString(), shellState.getPos().method_23854()}));
                return;
            }
            if (!skipOnFailure) {
                logger.accept((class_2561)class_2561.method_43469((String)"command.sync.ghostshells.failed", (Object[])new Object[]{player.method_5477().getString(), shellState.getPos().method_23854()}));
                return;
            }
        }
        ((Shell)player).remove(shellState);
        logger.accept((class_2561)class_2561.method_43469((String)"command.sync.ghostshells.removed", (Object[])new Object[]{player.method_5477().getString(), shellState.getPos().method_23854()}));
    }

    private static boolean shellExists(MinecraftServer server, ShellState shellState) {
        return GhostShellsCommand.getShellContainer(server, shellState).map(x -> shellState.equals(x.getShellState())).orElse(Boolean.FALSE);
    }

    private static boolean tryRepair(MinecraftServer server, ShellState shellState) {
        ShellStateContainer shellContainer = GhostShellsCommand.getShellContainer(server, shellState).orElse(null);
        if (shellContainer == null) {
            return false;
        }
        if (shellContainer.getShellState() == null) {
            shellContainer.setShellState(shellState);
        }
        return shellState.equals(shellContainer.getShellState());
    }

    private static Optional<ShellStateContainer> getShellContainer(MinecraftServer server, ShellState shellState) {
        class_3218 world = WorldUtil.findWorld(server.method_3738(), shellState.getWorld()).orElse(null);
        if (world == null) {
            return Optional.empty();
        }
        class_2791 chunk = world.method_22350(shellState.getPos());
        if (chunk == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(ShellStateContainer.find((class_1937)world, shellState));
    }
}

