/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.config;

import dev.kir.sync.api.shell.ShellPriority;
import dev.kir.sync.compat.cloth.SyncClothConfig;
import java.util.List;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public interface SyncConfig {
    public static final List<EnergyMapEntry> DEFAULT_ENERGY_MAP = List.of(EnergyMapEntry.of(class_1299.field_6132, 2L), EnergyMapEntry.of(class_1299.field_6093, 16L), EnergyMapEntry.of(class_1299.field_6097, 20L), EnergyMapEntry.of(class_1299.field_6055, 24L), EnergyMapEntry.of(class_1299.field_6046, 80L), EnergyMapEntry.of(class_1299.field_6091, 160L));
    public static final List<ShellPriorityEntry> DEFAULT_SYNC_PRIORITY = List.of(new ShellPriorityEntry(){});

    public static SyncConfig resolve() {
        return FabricLoader.getInstance().isModLoaded("cloth-config") ? SyncClothConfig.getInstance() : new SyncConfig(){};
    }

    default public boolean enableInstantShellConstruction() {
        return false;
    }

    default public boolean warnPlayerInsteadOfKilling() {
        return false;
    }

    default public float fingerstickDamage() {
        return 20.0f;
    }

    default public float hardcoreFingerstickDamage() {
        return 40.0f;
    }

    default public long shellConstructorCapacity() {
        return 256000L;
    }

    default public long shellStorageCapacity() {
        return 320L;
    }

    default public long shellStorageConsumption() {
        return 16L;
    }

    default public boolean shellStorageAcceptsRedstone() {
        return true;
    }

    default public int shellStorageMaxUnpoweredLifespan() {
        return 20;
    }

    default public List<EnergyMapEntry> energyMap() {
        return DEFAULT_ENERGY_MAP;
    }

    default public List<ShellPriorityEntry> syncPriority() {
        return DEFAULT_SYNC_PRIORITY;
    }

    default public String wrench() {
        return "minecraft:stick";
    }

    default public boolean updateTranslationsAutomatically() {
        return false;
    }

    default public boolean preserveOrigins() {
        return false;
    }

    default public boolean enableTechnobladeEasterEgg() {
        return true;
    }

    default public boolean renderTechnobladeCape() {
        return false;
    }

    default public boolean allowTechnobladeAnnouncements() {
        return true;
    }

    default public boolean allowTechnobladeQuotes() {
        return true;
    }

    default public int TechnobladeQuoteDelay() {
        return 1800;
    }

    default public boolean isTechnoblade(UUID uuid) {
        return false;
    }

    default public void addTechnoblade(UUID uuid) {
    }

    default public void removeTechnoblade(UUID uuid) {
    }

    default public void clearTechnobladeCache() {
    }

    public static interface EnergyMapEntry {
        default public String entityId() {
            return "minecraft:pig";
        }

        default public long outputEnergyQuantity() {
            return 16L;
        }

        default public class_1299<?> getEntityType() {
            class_2960 id = class_2960.method_12829((String)this.entityId());
            return id == null ? class_1299.field_6093 : (class_1299)class_7923.field_41177.method_10223(id);
        }

        public static EnergyMapEntry of(class_1299<?> entityType, long outputEnergyQuantity) {
            return EnergyMapEntry.of(class_7923.field_41177.method_10221(entityType).toString(), outputEnergyQuantity);
        }

        public static EnergyMapEntry of(final String id, final long outputEnergyQuantity) {
            return new EnergyMapEntry(){

                @Override
                public String entityId() {
                    return id;
                }

                @Override
                public long outputEnergyQuantity() {
                    return outputEnergyQuantity;
                }
            };
        }
    }

    public static interface ShellPriorityEntry {
        default public ShellPriority priority() {
            return ShellPriority.NATURAL;
        }
    }
}

