/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import dev.kir.sync.entity.PersistentCameraEntityGoal;
import java.util.Date;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class PersistentCameraEntity
extends class_746 {
    private long lastMovementTime;
    private float initialYaw;
    private float initialPitch;
    private double initialDistance;
    private PersistentCameraEntityGoal goal;

    private PersistentCameraEntity(class_310 client) {
        super(client, Objects.requireNonNull(client.field_1724).field_17892, client.field_1724.field_3944, client.field_1724.method_3143(), client.field_1724.method_3130(), false, false);
        class_746 player = client.field_1724;
        this.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        this.method_5710(player.method_36454(), player.method_36455());
        this.updateLastTickValues();
        this.field_5960 = true;
    }

    public boolean method_7325() {
        return true;
    }

    public void method_6007() {
        PersistentCameraEntityGoal goal = this.goal;
        long currentTime = new Date().getTime();
        if (goal == null || this.lastMovementTime < 0L) {
            this.lastMovementTime = currentTime;
            return;
        }
        if (this.lastMovementTime > currentTime) {
            return;
        }
        this.updateLastTickValues();
        class_243 currentPos = this.method_19538();
        class_243 currentVelocity = this.method_18798();
        class_243 newPos = currentPos.method_1019(currentVelocity.method_1021((double)(currentTime - this.lastMovementTime)));
        class_243 currentDiff = goal.pos.method_1020(currentPos);
        class_243 newDiff = goal.pos.method_1020(newPos);
        if (Math.signum(currentDiff.field_1352) != Math.signum(newDiff.field_1352)) {
            newPos = new class_243(goal.pos.field_1352, newPos.field_1351, newPos.field_1350);
            currentVelocity = new class_243(0.0, currentVelocity.field_1351, currentVelocity.field_1350);
        }
        if (Math.signum(currentDiff.field_1351) != Math.signum(newDiff.field_1351)) {
            newPos = new class_243(newPos.field_1352, goal.pos.field_1351, newPos.field_1350);
            currentVelocity = new class_243(currentVelocity.field_1352, 0.0, currentVelocity.field_1350);
        }
        if (Math.signum(currentDiff.field_1350) != Math.signum(newDiff.field_1350)) {
            newPos = new class_243(newPos.field_1352, newPos.field_1351, goal.pos.field_1350);
            currentVelocity = new class_243(currentVelocity.field_1352, currentVelocity.field_1351, 0.0);
        }
        this.method_33574(newPos);
        this.method_18799(currentVelocity);
        float factor = 1.0f - (float)(goal.pos.method_1022(newPos) / this.initialDistance);
        float newYaw = this.initialYaw + (goal.yaw - this.initialYaw) * factor;
        float newPitch = this.initialPitch + (goal.pitch - this.initialPitch) * factor;
        this.method_5808(newPos.field_1352, newPos.field_1351, newPos.field_1350, newYaw, newPitch);
        this.method_5710(newYaw, newPitch);
        this.method_36456(newYaw);
        this.method_5847(newYaw);
        this.method_5636(newYaw);
        this.field_3932 += (newYaw - this.field_3932) * 0.5f;
        this.field_3916 += (newPitch - this.field_3916) * 0.5f;
        this.lastMovementTime = currentTime;
        if (this.method_19538().equals((Object)goal.pos)) {
            this.updateLastTickValues();
            this.setGoal(null);
            goal.finish(this);
        }
    }

    private void updateLastTickValues() {
        this.field_6038 = this.method_23317();
        this.field_5971 = this.method_23318();
        this.field_5989 = this.method_23321();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.field_3931 = this.field_3932;
        this.field_3914 = this.field_3916;
        this.field_6259 = this.field_6241;
    }

    public void setGoal(PersistentCameraEntityGoal goal) {
        this.goal = goal;
        this.initialYaw = this.method_36454();
        this.initialPitch = this.method_36455();
        this.lastMovementTime = -1L;
        double dX = 0.0;
        double dY = 0.0;
        double dZ = 0.0;
        double duration = 0.0;
        if (goal != null) {
            class_243 pos = this.method_19538();
            dX = goal.pos.field_1352 - pos.field_1352;
            dY = goal.pos.field_1351 - pos.field_1351;
            dZ = goal.pos.field_1350 - pos.field_1350;
            duration = goal.duration;
            if (goal.delay > 0L) {
                this.lastMovementTime = new Date().getTime() + goal.delay;
            }
        }
        this.initialDistance = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
        this.method_18799(new class_243(dX, dY, dZ).method_1021(1.0 / Math.max(1.0, duration)));
    }

    public PersistentCameraEntityGoal getGoal() {
        return this.goal;
    }

    public static void setup(class_310 client, PersistentCameraEntityGoal goal) {
        class_746 player = client.field_1724;
        if (player == null || player.field_17892 == null) {
            return;
        }
        if (!(client.method_1560() instanceof PersistentCameraEntity)) {
            client.method_1504((class_1297)new PersistentCameraEntity(client));
        }
        PersistentCameraEntity camera = (PersistentCameraEntity)Objects.requireNonNull(client.method_1560());
        camera.setGoal(goal);
    }

    public static void unset(class_310 client) {
        class_1297 class_12972 = client.method_1560();
        if (class_12972 instanceof PersistentCameraEntity) {
            PersistentCameraEntity camera = (PersistentCameraEntity)class_12972;
            camera.setGoal(null);
            client.method_1504((class_1297)client.field_1724);
        }
    }

    private static void onTick(class_310 client) {
        PersistentCameraEntity camera;
        block3: {
            block2: {
                class_1297 class_12972 = client.method_1560();
                if (!(class_12972 instanceof PersistentCameraEntity)) break block2;
                camera = (PersistentCameraEntity)class_12972;
                if (camera.goal != null) break block3;
            }
            return;
        }
        camera.method_6007();
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(PersistentCameraEntity::onTick);
    }
}

