/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.entity;

import dev.kir.sync.entity.PersistentCameraEntity;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;

@Environment(value=EnvType.CLIENT)
public class PersistentCameraEntityGoal {
    public static final double MAX_DISTANCE = 25.0;
    public static final long PHASE_DELAY = 200L;
    public static final double MAX_Y = 320.0;
    public static final long MIN_PHASE_DURATION = 400L;
    public static final long MAX_PHASE_DURATION = 2500L;
    public final class_243 pos;
    public final float yaw;
    public final float pitch;
    public final long delay;
    public final long duration;
    private final Consumer<PersistentCameraEntity> onTransitionFinished;

    private PersistentCameraEntityGoal(class_243 pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        this.pos = pos;
        this.yaw = yaw;
        this.pitch = pitch;
        this.delay = delay;
        this.duration = duration;
        this.onTransitionFinished = onTransitionFinished;
    }

    public void finish(PersistentCameraEntity camera) {
        if (this.onTransitionFinished != null) {
            this.onTransitionFinished.accept(camera);
        }
    }

    public PersistentCameraEntityGoal then(PersistentCameraEntityGoal nextGoal) {
        return this.then((PersistentCameraEntity camera) -> camera.setGoal(nextGoal));
    }

    public PersistentCameraEntityGoal then(Consumer<PersistentCameraEntity> callback) {
        Consumer<PersistentCameraEntity> combined = callback == null ? this.onTransitionFinished : (this.onTransitionFinished == null ? callback : this.onTransitionFinished.andThen(callback));
        return new PersistentCameraEntityGoal(this.pos, this.yaw, this.pitch, this.delay, this.duration, combined);
    }

    public static PersistentCameraEntityGoal create(class_2338 pos, float yaw, float pitch, long duration) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, duration, null);
    }

    public static PersistentCameraEntityGoal create(class_2338 pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        class_243 vecPos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        return PersistentCameraEntityGoal.create(vecPos, yaw, pitch, delay, duration, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal create(class_243 pos, float yaw, float pitch, long duration) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, duration, null);
    }

    public static PersistentCameraEntityGoal create(class_243 pos, float yaw, float pitch, long delay, long duration, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return new PersistentCameraEntityGoal(pos, yaw, pitch, delay, duration, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal tp(class_2338 pos, float yaw, float pitch) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, 0L, null);
    }

    public static PersistentCameraEntityGoal tp(class_2338 pos, float yaw, float pitch, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.create(pos, yaw, pitch, 0L, 0L, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal limbo(class_2338 start, class_2350 startFacing, class_2338 target, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.limbo(start, startFacing, 320.0, target, 400L, 2500L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal limbo(class_2338 start, class_2350 startFacing, double y, class_2338 target, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        double dX = target.method_10263() - start.method_10263();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = (double)(target.method_10260() - start.method_10260())) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            target = new class_2338((class_2382)start.method_10069((int)(dX * factor), 0, (int)(dZ * factor)));
        }
        float yaw = startFacing.method_10144();
        float pitch = 90.0f;
        class_2338 pos0 = start.method_10093(class_2350.field_11036);
        class_243 pos1 = new class_243((double)(start.method_10263() + target.method_10263()), y * 2.0, (double)(start.method_10260() + target.method_10260())).method_1021(0.5);
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw, pitch, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(pos1, yaw, pitch, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return goal0.then(goal1);
    }

    public static PersistentCameraEntityGoal stairwayToHeaven(class_2338 start, class_2350 startFacing, class_2338 target, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.stairwayToHeaven(start, startFacing, 320.0, target, 400L, 2500L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal stairwayToHeaven(class_2338 start, class_2350 startFacing, double y, class_2338 target, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        double dX = target.method_10263() - start.method_10263();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = (double)(target.method_10260() - start.method_10260())) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            target = new class_2338((class_2382)start.method_10069((int)(dX * factor), 0, (int)(dZ * factor)));
        }
        float yaw = startFacing.method_10144();
        float pitch = 90.0f;
        class_2338 pos0 = start.method_10093(startFacing.method_10153());
        class_243 pos1 = new class_243((double)(start.method_10263() + target.method_10263()), y * 2.0, (double)(start.method_10260() + target.method_10260())).method_1021(0.5);
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw, 0.0f, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(pos1, yaw, pitch, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return goal0.then(goal1);
    }

    public static PersistentCameraEntityGoal highwayToHell(class_2338 start, class_2350 startFacing, class_2338 target, class_2350 targetFacing, Consumer<PersistentCameraEntity> onTransitionFinished) {
        return PersistentCameraEntityGoal.highwayToHell(start, startFacing, 320.0, target, targetFacing, 2500L, 400L, 200L, 25.0, onTransitionFinished);
    }

    public static PersistentCameraEntityGoal highwayToHell(class_2338 start, class_2350 startFacing, double y, class_2338 target, class_2350 targetFacing, long firstPhaseDuration, long secondPhaseDuration, long phaseDelay, double maxDistance, Consumer<PersistentCameraEntity> onTransitionFinished) {
        double dZ;
        class_2338 pos0 = target.method_10093(targetFacing.method_10153());
        float yaw0 = targetFacing.method_10144();
        float yaw1 = targetFacing.method_10153().method_10144();
        class_243 centerPoint = new class_243((double)(start.method_10263() + target.method_10263()), y * 2.0, (double)(start.method_10260() + target.method_10260())).method_1021(0.5);
        PersistentCameraEntityGoal tpGoal = null;
        double dX = centerPoint.field_1352 - (double)target.method_10263();
        double horizontalDistance = Math.sqrt(dX * dX + (dZ = centerPoint.field_1350 - (double)target.method_10260()) * dZ);
        if (horizontalDistance > maxDistance) {
            double factor = maxDistance / horizontalDistance;
            class_2338 centerPointPos = new class_2338((class_2382)target.method_10069((int)(dX * factor), 0, (int)(dZ * factor))).method_33096((int)centerPoint.field_1351);
            tpGoal = PersistentCameraEntityGoal.tp(centerPointPos, startFacing.method_10144(), 90.0f);
        }
        PersistentCameraEntityGoal goal0 = PersistentCameraEntityGoal.create(pos0, yaw0, 0.0f, firstPhaseDuration);
        PersistentCameraEntityGoal goal1 = PersistentCameraEntityGoal.create(target, yaw1, 0.0f, phaseDelay, secondPhaseDuration, onTransitionFinished);
        return tpGoal == null ? goal0.then(goal1) : tpGoal.then(goal0.then(goal1));
    }
}

