/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class RenderSystemUtil {
    public static final int MAX_LIGHT_LEVEL = 0xF000F0;
    private static final class_4599 BUFFER_BUILDER_STORAGE = new class_4599();

    public static void drawTriangleStrip(Consumer<class_4588> consumer) {
        RenderSystemUtil.drawTriangleStrip(consumer, class_290.field_1576);
    }

    public static void drawTriangleStrip(Consumer<class_4588> consumer, class_293 format) {
        RenderSystemUtil.draw(consumer, class_293.class_5596.field_27380, format);
    }

    public static void drawAnnulusSector(class_4587 matrices, double cX, double cY, double majorR, double minorR, double from, double to, double step, float r, float g, float b, float a) {
        RenderSystemUtil.drawTriangleStrip(consumer -> RenderSystemUtil.drawAnnulusSector(matrices, consumer, cX, cY, majorR, minorR, from, to, step, r, g, b, a));
    }

    public static void drawAnnulusSector(class_4587 matrices, class_4588 consumer, double cX, double cY, double majorR, double minorR, double from, double to, double step, float r, float g, float b, float a) {
        to += step / 32.0;
        Matrix4f matrix = matrices.method_23760().method_23761();
        for (double i = from; i < to; i += step) {
            double sin = Math.sin(i);
            double cos = Math.cos(i);
            double x0 = majorR * cos + cX;
            double y0 = majorR * sin + cY;
            double x1 = minorR * cos + cX;
            double y1 = minorR * sin + cY;
            consumer.method_22918(matrix, (float)x0, (float)y0, 0.0f).method_22915(r, g, b, a).method_1344();
            consumer.method_22918(matrix, (float)x1, (float)y1, 0.0f).method_22915(r, g, b, a).method_1344();
        }
    }

    public static void drawRectangle(class_4587 matrices, float x, float y, float width, float height, float borderRadius, float scale, float rotation, float step, float r, float g, float b, float a) {
        RenderSystemUtil.drawTriangleStrip(consumer -> RenderSystemUtil.drawRectangle(matrices, consumer, x, y, width, height, borderRadius, scale, rotation, step, r, g, b, a));
    }

    public static void drawRectangle(class_4587 matrices, class_4588 consumer, float x, float y, float width, float height, float borderRadius, float scale, float rotation, float step, float r, float g, float b, float a) {
        matrices.method_22903();
        matrices.method_46416(x, y, 0.0f);
        matrices.method_22907(class_7833.field_40718.rotation(rotation));
        matrices.method_22905(scale, scale, 1.0f);
        matrices.method_46416(-x, -y, 0.0f);
        Matrix4f matrix = matrices.method_23760().method_23761();
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + width - borderRadius, y + height - borderRadius, borderRadius, 0, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + borderRadius, y + height - borderRadius, borderRadius, 1, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + borderRadius, y + borderRadius, borderRadius, 2, step, r, g, b, a);
        RenderSystemUtil.drawQuadrant(matrix, consumer, x + width - borderRadius, y + borderRadius, borderRadius, 3, step, r, g, b, a);
        consumer.method_22918(matrix, x + width, y + height - borderRadius, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, x + borderRadius, y + borderRadius, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, x + borderRadius, y + height - borderRadius, 0.0f).method_22915(r, g, b, a).method_1344();
        matrices.method_22909();
    }

    private static void drawQuadrant(Matrix4f matrix, class_4588 consumer, float cX, float cY, float radius, int index, float step, float r, float g, float b, float a) {
        float start = 1.5707964f * (float)index;
        float end = 1.5707964f * (float)(index + 1);
        for (float i = start; i < end; i += step) {
            float x = radius * (float)Math.cos(i) + cX;
            float y = radius * (float)Math.sin(i) + cY;
            consumer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a).method_1344();
            consumer.method_22918(matrix, cX, cY, 0.0f).method_22915(r, g, b, a).method_1344();
        }
        float x = radius * (float)Math.cos(end) + cX;
        float y = radius * (float)Math.sin(end) + cY;
        consumer.method_22918(matrix, x, y, 0.0f).method_22915(r, g, b, a).method_1344();
        consumer.method_22918(matrix, cX, cY, 0.0f).method_22915(r, g, b, a).method_1344();
    }

    public static void draw(Consumer<class_4588> consumer, class_293.class_5596 drawMode, class_293 format) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(drawMode, format);
        consumer.accept((class_4588)bufferBuilder);
        class_286.method_43433((class_287.class_7433)bufferBuilder.method_1326());
        RenderSystem.disableBlend();
    }

    public static class_327 getTextRenderer() {
        return class_310.method_1551().field_1772;
    }

    public static class_4597.class_4598 getEntityVertexConsumerProvider() {
        return BUFFER_BUILDER_STORAGE.method_23000();
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, float cX, float cY, int color) {
        RenderSystemUtil.drawCenteredText(drawContext, text, cX, cY, 1.0f, color);
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, float cX, float cY, float scale, int color) {
        RenderSystemUtil.drawCenteredText(drawContext, text, cX, cY, scale, color, false);
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, float cX, float cY, float scale, int color, boolean shadow) {
        RenderSystemUtil.drawCenteredText(drawContext, text, RenderSystemUtil.getTextRenderer(), cX, cY, scale, color, shadow);
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, class_327 textRenderer, float cX, float cY, float scale, int color, boolean shadow) {
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        RenderSystemUtil.drawCenteredText(drawContext, text, (class_4597)immediate, textRenderer, cX, cY, scale, color, shadow);
        immediate.method_22993();
    }

    public static void drawCenteredText(class_332 drawContext, class_2561 text, class_4597 vertexConsumers, class_327 textRenderer, float cX, float cY, float scale, int color, boolean shadow) {
        boolean backgroundColor = false;
        Objects.requireNonNull(textRenderer);
        float height = 9.0f * scale;
        float width = (float)textRenderer.method_27525((class_5348)text) * scale;
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();
        matrices.method_46416(cX -= width / 2.0f, cY -= height / 2.0f, 0.0f);
        matrices.method_22905(scale, scale, 1.0f);
        matrices.method_46416(-cX, -cY, 0.0f);
        drawContext.method_51439(textRenderer, text, (int)cX, (int)cY, color, shadow);
        matrices.method_22909();
    }
}

