/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.nbt;

import dev.kir.sync.util.nbt.NbtSerializerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class NbtSerializerFactoryBuilder<TTarget> {
    private static final Map<Class<?>, BiFunction<class_2487, String, ?>> NBT_GETTERS = new HashMap();
    private static final Map<Class<?>, TriConsumer<class_2487, String, ?>> NBT_SETTERS;
    private final Collection<BiConsumer<TTarget, class_2487>> readers = new ArrayList<BiConsumer<TTarget, class_2487>>();
    private final Collection<BiConsumer<TTarget, class_2487>> writers = new ArrayList<BiConsumer<TTarget, class_2487>>();

    public <TProperty> NbtSerializerFactoryBuilder<TTarget> add(Class<TProperty> type, String key, Function<TTarget, TProperty> getter, BiConsumer<TTarget, TProperty> setter) {
        if (getter != null) {
            TriConsumer<class_2487, String, ?> nbtSetter = NBT_SETTERS.get(type);
            if (nbtSetter == null) {
                throw new UnsupportedOperationException();
            }
            this.writers.add((i, x) -> nbtSetter.accept((class_2487)x, key, getter.apply(i)));
        }
        if (setter != null) {
            BiFunction<class_2487, String, ?> nbtGetter = NBT_GETTERS.get(type);
            if (nbtGetter == null) {
                throw new UnsupportedOperationException();
            }
            this.readers.add((i, x) -> setter.accept(i, nbtGetter.apply((class_2487)x, key)));
        }
        return this;
    }

    public NbtSerializerFactory<TTarget> build() {
        return new NbtSerializerFactory(this.readers, this.writers);
    }

    private static BiFunction<class_2487, String, ?> getOrDefault(BiFunction<class_2487, String, ?> f) {
        return (nbt, key) -> nbt.method_10545(key) ? f.apply((class_2487)nbt, (String)key) : null;
    }

    private static TriConsumer<class_2487, String, ?> setIfNotNull(TriConsumer<class_2487, String, Object> f) {
        return (nbt, key, x) -> {
            if (x != null) {
                f.accept((class_2487)nbt, (String)key, x);
            }
        };
    }

    static {
        NBT_GETTERS.put(Boolean.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10577));
        NBT_GETTERS.put(Byte.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10571));
        NBT_GETTERS.put(Double.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10574));
        NBT_GETTERS.put(Float.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10583));
        NBT_GETTERS.put(Integer.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10550));
        NBT_GETTERS.put(Long.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10537));
        NBT_GETTERS.put(Short.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10568));
        NBT_GETTERS.put(String.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10558));
        NBT_GETTERS.put(class_2960.class, NbtSerializerFactoryBuilder.getOrDefault((x, key) -> new class_2960(x.method_10558(key))));
        NBT_GETTERS.put(UUID.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_25926));
        NBT_GETTERS.put(class_2487.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10562));
        NBT_GETTERS.put(class_2499.class, NbtSerializerFactoryBuilder.getOrDefault(class_2487::method_10580));
        NBT_GETTERS.put(class_2338.class, NbtSerializerFactoryBuilder.getOrDefault((nbt, key) -> {
            class_2487 compound = nbt.method_10562(key);
            return new class_2338(compound.method_10550("x"), compound.method_10550("y"), compound.method_10550("z"));
        }));
        NBT_SETTERS = new HashMap();
        NBT_SETTERS.put(Boolean.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10556(key, ((Boolean)x).booleanValue())));
        NBT_SETTERS.put(Byte.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10567(key, ((Byte)x).byteValue())));
        NBT_SETTERS.put(Double.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10549(key, ((Double)x).doubleValue())));
        NBT_SETTERS.put(Float.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10548(key, ((Float)x).floatValue())));
        NBT_SETTERS.put(Integer.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10569(key, ((Integer)x).intValue())));
        NBT_SETTERS.put(Long.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10544(key, ((Long)x).longValue())));
        NBT_SETTERS.put(Short.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10575(key, ((Short)x).shortValue())));
        NBT_SETTERS.put(String.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10582(key, (String)x)));
        NBT_SETTERS.put(class_2960.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10582(key, x.toString())));
        NBT_SETTERS.put(UUID.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_25927(key, (UUID)x)));
        NBT_SETTERS.put(class_2487.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10566(key, (class_2520)((class_2487)x))));
        NBT_SETTERS.put(class_2499.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> nbt.method_10566(key, (class_2520)((class_2499)x))));
        NBT_SETTERS.put(class_2338.class, NbtSerializerFactoryBuilder.setIfNotNull((nbt, key, x) -> {
            class_2338 pos = (class_2338)x;
            class_2487 compound = new class_2487();
            compound.method_10569("x", pos.method_10263());
            compound.method_10569("y", pos.method_10264());
            compound.method_10569("z", pos.method_10260());
            nbt.method_10566(key, (class_2520)compound);
        }));
    }

    @FunctionalInterface
    private static interface TriConsumer<T, K, V> {
        public void accept(T var1, K var2, V var3);
    }
}

