/*
 * Decompiled with CFR 0.152.
 */
package dev.kir.sync.util.nbt;

import java.io.File;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class OfflinePlayerNbtManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DATA_FILE_EXTENSION = ".dat";

    public static void editPlayerNbt(MinecraftServer server, UUID uuid, Consumer<class_2487> nbtEditor) {
        OfflinePlayerNbtManager.editPlayerNbt(server, uuid, (class_2487 nbt) -> {
            nbtEditor.accept((class_2487)nbt);
            return nbt;
        });
    }

    public static void editPlayerNbt(MinecraftServer server, UUID uuid, Function<class_2487, class_2487> nbtEditor) {
        File nbtPath = server.method_27050(class_5218.field_24182).resolve(uuid.toString() + DATA_FILE_EXTENSION).toFile();
        try {
            if (!nbtPath.isFile()) {
                return;
            }
            class_2487 nbt = class_2507.method_30613((File)nbtPath);
            nbt = nbtEditor.apply(nbt);
            class_2507.method_30614((class_2487)nbt, (File)nbtPath);
        }
        catch (Throwable exception) {
            LOGGER.log(Level.ERROR, "Failed to edit player's nbt.", exception);
        }
    }
}

