/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.writer;

public enum LineDelimiter {
    LF("\n"),
    CR("\r"),
    CRLF("\r\n"),
    PLATFORM(System.lineSeparator());

    private final String str;

    private LineDelimiter(String str) {
        this.str = str;
    }

    public static LineDelimiter of(String str) {
        if ("\r\n".equals(str)) {
            return CRLF;
        }
        if ("\n".equals(str)) {
            return LF;
        }
        if ("\r".equals(str)) {
            return CR;
        }
        throw new IllegalArgumentException("Unknown line delimiter: " + str);
    }

    public String toString() {
        return this.str;
    }
}

