/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.blocks;

import java.util.function.Supplier;
import net.creeperhost.polylib.blocks.ChangeListener;
import net.creeperhost.polylib.blocks.DataRetainingBlock;
import net.creeperhost.polylib.blocks.InteractableBlock;
import net.creeperhost.polylib.blocks.PolyBlock;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneEmitter;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PolyEntityBlock
extends PolyBlock
implements EntityBlock {
    public static final String POLY_TILE_DATA_TAG = "poly_tile_data";
    private Supplier<BlockEntityType<? extends PolyBlockEntity>> blockEntityType = null;
    private boolean enableTicking;

    public PolyEntityBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public PolyEntityBlock setBlockEntity(Supplier<BlockEntityType<? extends PolyBlockEntity>> blockEntityType, boolean enableTicking) {
        this.blockEntityType = blockEntityType;
        this.enableTicking = enableTicking;
        return this;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.blockEntityType.get().m_155264_(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (this.enableTicking && this.blockEntityType.get() == entityType) {
            return (e, e2, e3, tile) -> ((PolyBlockEntity)tile).tick();
        }
        return null;
    }

    public int m_6378_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.m_7702_(pos);
        if (blockEntity instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)blockEntity;
            return emitter.getWeakPower(state, side);
        }
        return super.m_6378_(state, blockAccess, pos, side);
    }

    public int m_6376_(BlockState state, BlockGetter blockAccess, BlockPos pos, Direction side) {
        BlockEntity blockEntity = blockAccess.m_7702_(pos);
        if (blockEntity instanceof RedstoneEmitter) {
            RedstoneEmitter emitter = (RedstoneEmitter)blockEntity;
            return emitter.getStrongPower(state, side);
        }
        return super.m_6376_(state, blockAccess, pos, side);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ChangeListener) {
            ChangeListener listener = (ChangeListener)blockEntity;
            listener.onNeighborChange(blockIn, fromPos, isMoving);
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)blockEntity;
            return interactable.onBlockUse(player, hand, hit);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_6256_(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InteractableBlock) {
            InteractableBlock interactable = (InteractableBlock)blockEntity;
            interactable.onBlockAttack(player);
        }
        super.m_6256_(state, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DataRetainingBlock) {
            DataRetainingBlock retaining = (DataRetainingBlock)blockEntity;
            if (stack.m_41782_() && stack.m_41783_().m_128441_(POLY_TILE_DATA_TAG)) {
                retaining.readFromItemStack(stack.m_41737_(POLY_TILE_DATA_TAG));
            }
        }
        if (blockEntity instanceof PolyBlockEntity) {
            PolyBlockEntity polyBlock = (PolyBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                polyBlock.setCustomName(stack.m_41786_());
            }
        }
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        DataRetainingBlock retaining;
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem() && (level instanceof ServerLevel || !this.isCTRLKeyDown())) {
            CompoundTag nbt = new CompoundTag();
            ((DataRetainingBlock)blockEntity).writeToItemStack(nbt, false);
            if (!nbt.m_128456_()) {
                stack.m_41784_().m_128365_(POLY_TILE_DATA_TAG, (Tag)nbt);
            }
        }
        if (blockEntity instanceof Nameable && ((Nameable)blockEntity).m_8077_()) {
            stack.m_41714_(((Nameable)blockEntity).m_7755_());
        }
        return stack;
    }

    private boolean isCTRLKeyDown() {
        return Screen.m_96637_();
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity, ItemStack heldStack) {
        Nameable nameable;
        DataRetainingBlock retaining;
        ItemStack stack = ItemStack.f_41583_;
        if (blockEntity instanceof DataRetainingBlock && (retaining = (DataRetainingBlock)blockEntity).saveToItem()) {
            CompoundTag nbt = new CompoundTag();
            retaining.writeToItemStack(nbt, true);
            if (!nbt.m_128456_()) {
                stack = new ItemStack((ItemLike)this, 1);
                stack.m_41784_().m_128365_(POLY_TILE_DATA_TAG, (Tag)nbt);
            }
        }
        if (blockEntity instanceof Nameable && (nameable = (Nameable)blockEntity).m_8077_()) {
            if (stack.m_41619_()) {
                stack = new ItemStack((ItemLike)this, 1);
            }
            stack.m_41714_(nameable.m_7755_());
        }
        if (!stack.m_41619_()) {
            player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
            player.m_36399_(0.005f);
            PolyEntityBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
            level.m_46747_(pos);
        } else {
            super.m_6240_(level, player, pos, state, blockEntity, heldStack);
        }
    }
}

