/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.helpers;

import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerUtil {
    public static int insertStack(ItemStack stack, Container container) {
        return ContainerUtil.insertStack(stack, container, false);
    }

    public static int insertStack(ItemStack stack, Container container, boolean simulate) {
        int slot;
        ItemStack copy = stack.m_41777_();
        for (slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack inSlot = container.m_8020_(slot);
            if (inSlot.m_41619_() || !ContainerUtil.canCombine(copy, inSlot, container.m_6893_()) || !container.m_7013_(slot, copy)) continue;
            int add = Math.min(copy.m_41613_(), inSlot.m_41741_() - inSlot.m_41613_());
            if (!simulate) {
                inSlot.m_41769_(add);
                container.m_6836_(slot, inSlot);
            }
            copy.m_41774_(add);
            if (!copy.m_41619_()) continue;
            return 0;
        }
        for (slot = 0; slot < container.m_6643_(); ++slot) {
            if (!container.m_8020_(slot).m_41619_() || !container.m_7013_(slot, copy)) continue;
            if (!simulate) {
                container.m_6836_(slot, copy);
            }
            return 0;
        }
        return copy.m_41613_();
    }

    public static boolean canCombine(ItemStack stack, ItemStack combineWith) {
        return ContainerUtil.canCombine(stack, combineWith, 64);
    }

    public static boolean canCombine(ItemStack stack, ItemStack combineWith, int maxStackSize) {
        return !stack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)combineWith) && stack.m_41753_() && combineWith.m_41613_() < combineWith.m_41741_() && combineWith.m_41613_() < maxStackSize;
    }

    @NotNull
    public static ItemStack insertItem(Container container, int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = container.m_8020_(slot);
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), container.m_6893_())) {
                return stack;
            }
            if (!ContainerUtil.canCombine(stack, stackInSlot)) {
                return stack;
            }
            if (!container.m_7013_(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.m_41741_(), container.m_6893_()) - stackInSlot.m_41613_();
            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    container.m_6836_(slot, copy);
                    container.m_6596_();
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(m);
                copy.m_41769_(stackInSlot.m_41613_());
                container.m_6836_(slot, copy);
                container.m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!container.m_7013_(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.m_41741_(), container.m_6893_());
        if (m < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                container.m_6836_(slot, stack.m_41620_(m));
                container.m_6596_();
                return stack;
            }
            stack.m_41774_(m);
            return stack;
        }
        if (!simulate) {
            container.m_6836_(slot, stack);
            container.m_6596_();
        }
        return ItemStack.f_41583_;
    }

    @NotNull
    public static ItemStack extractItem(Container container, int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = container.m_8020_(slot);
        if (stackInSlot.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            }
            ItemStack copy = stackInSlot.m_41777_();
            copy.m_41764_(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.m_41613_(), amount);
        ItemStack decrStackSize = container.m_7407_(slot, m);
        container.m_6596_();
        return decrStackSize;
    }
}

