/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry;

import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.polylib.io.sentry.DateUtils;
import net.creeperhost.polylib.io.sentry.IUnknownPropertiesConsumer;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.util.CollectionUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Breadcrumb
implements IUnknownPropertiesConsumer {
    @NotNull
    private final Date timestamp;
    @Nullable
    private String message;
    @Nullable
    private String type;
    @NotNull
    private @NotNull Map<String, @NotNull Object> data = new ConcurrentHashMap<String, Object>();
    @Nullable
    private String category;
    @Nullable
    private SentryLevel level;
    @Nullable
    private Map<String, Object> unknown;

    public Breadcrumb(@NotNull Date timestamp) {
        this.timestamp = timestamp;
    }

    Breadcrumb(@NotNull Breadcrumb breadcrumb) {
        this.timestamp = breadcrumb.timestamp;
        this.message = breadcrumb.message;
        this.type = breadcrumb.type;
        this.category = breadcrumb.category;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb.data);
        if (dataClone != null) {
            this.data = dataClone;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb.unknown);
        this.level = breadcrumb.level;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("http");
        breadcrumb.setCategory("http");
        breadcrumb.setData("url", url);
        breadcrumb.setData("method", method.toUpperCase(Locale.ROOT));
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb http(@NotNull String url, @NotNull String method, @Nullable Integer code) {
        Breadcrumb breadcrumb = Breadcrumb.http(url, method);
        if (code != null) {
            breadcrumb.setData("status_code", code);
        }
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb navigation(@NotNull String from, @NotNull String to) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setCategory("navigation");
        breadcrumb.setType("navigation");
        breadcrumb.setData("from", from);
        breadcrumb.setData("to", to);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb transaction(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("default");
        breadcrumb.setCategory("sentry.transaction");
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb debug(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("debug");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.DEBUG);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb error(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("error");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.ERROR);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb info(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("info");
        breadcrumb.setMessage(message);
        breadcrumb.setLevel(SentryLevel.INFO);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb query(@NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("query");
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb ui(@NotNull String category, @NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("default");
        breadcrumb.setCategory("ui." + category);
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb user(@NotNull String category, @NotNull String message) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("user");
        breadcrumb.setCategory(category);
        breadcrumb.setMessage(message);
        return breadcrumb;
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass) {
        return Breadcrumb.userInteraction(subCategory, viewId, viewClass, Collections.emptyMap());
    }

    @NotNull
    public static Breadcrumb userInteraction(@NotNull String subCategory, @Nullable String viewId, @Nullable String viewClass, @NotNull Map<String, Object> additionalData) {
        Breadcrumb breadcrumb = new Breadcrumb();
        breadcrumb.setType("user");
        breadcrumb.setCategory("ui." + subCategory);
        if (viewId != null) {
            breadcrumb.setData("view.id", viewId);
        }
        if (viewClass != null) {
            breadcrumb.setData("view.class", viewClass);
        }
        for (Map.Entry<String, Object> entry : additionalData.entrySet()) {
            breadcrumb.getData().put(entry.getKey(), entry.getValue());
        }
        breadcrumb.setLevel(SentryLevel.INFO);
        return breadcrumb;
    }

    public Breadcrumb() {
        this(DateUtils.getCurrentDateTime());
    }

    public Breadcrumb(@Nullable String message) {
        this();
        this.message = message;
    }

    @NotNull
    public Date getTimestamp() {
        return (Date)this.timestamp.clone();
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public void setType(@Nullable String type) {
        this.type = type;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Nullable
    public Object getData(@NotNull String key) {
        return this.data.get(key);
    }

    public void setData(@NotNull String key, @NotNull Object value) {
        this.data.put(key, value);
    }

    public void removeData(@NotNull String key) {
        this.data.remove(key);
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    public void setCategory(@Nullable String category) {
        this.category = category;
    }

    @Nullable
    public SentryLevel getLevel() {
        return this.level;
    }

    public void setLevel(@Nullable SentryLevel level) {
        this.level = level;
    }

    @Override
    @ApiStatus.Internal
    public void acceptUnknownProperties(@NotNull Map<String, Object> unknown) {
        this.unknown = new ConcurrentHashMap<String, Object>(unknown);
    }

    @TestOnly
    @Nullable
    Map<String, Object> getUnknown() {
        return this.unknown;
    }
}

