/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.api.util;

import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.FloatBuffer;
import java.util.function.IntConsumer;
import ladysnake.satin.Satin;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.apiguardian.api.API;
import org.lwjgl.opengl.GL20;

public final class ShaderPrograms {
    private static final Int2ObjectMap<Object2IntMap<String>> uniformsCache = new Int2ObjectOpenHashMap();

    private ShaderPrograms() {
    }

    @API(status=API.Status.MAINTAINED)
    public static void useShader(int program) {
        if (Satin.areShadersDisabled()) {
            return;
        }
        ProgramManager.m_85578_((int)program);
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static void setAttribValue(int program, String attribName, IntConsumer operation) {
        if (Satin.areShadersDisabled() || program == 0) {
            return;
        }
        int attrib = Uniform.m_85639_((int)program, (CharSequence)attribName);
        if (attrib != -1) {
            operation.accept(attrib);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static void setUniformValue(int program, String uniformName, IntConsumer operation) {
        if (Satin.areShadersDisabled() || program == 0) {
            return;
        }
        int uniform = ShaderPrograms.getUniformLocation(program, uniformName);
        if (uniform != -1) {
            operation.accept(uniform);
        }
    }

    @API(status=API.Status.STABLE)
    public static void setUniform(int program, String uniformName, int value) {
        if (Satin.areShadersDisabled() || program == 0) {
            return;
        }
        int uniform = ShaderPrograms.getUniformLocation(program, uniformName);
        if (uniform != -1) {
            GL20.glUniform1i((int)uniform, (int)value);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static void setUniform(int program, String uniformName, float value) {
        if (Satin.areShadersDisabled() || program == 0) {
            return;
        }
        int uniform = ShaderPrograms.getUniformLocation(program, uniformName);
        if (uniform != -1) {
            GL20.glUniform1f((int)uniform, (float)value);
        }
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static void setUniform(int program, String uniformName, FloatBuffer mat4) {
        if (Satin.areShadersDisabled() || program == 0) {
            return;
        }
        int uniform = ShaderPrograms.getUniformLocation(program, uniformName);
        if (uniform != -1) {
            GL20.glUniformMatrix4fv((int)uniform, (boolean)false, (FloatBuffer)mat4);
        }
    }

    @API(status=API.Status.MAINTAINED)
    public static int getUniformLocation(int program, String uniformName) {
        int uniform;
        Object2IntMap shaderUniformsCache = (Object2IntMap)uniformsCache.get(program);
        if (shaderUniformsCache == null) {
            shaderUniformsCache = new Object2IntOpenHashMap();
            uniformsCache.put(program, (Object)shaderUniformsCache);
        }
        if (shaderUniformsCache.containsKey((Object)uniformName)) {
            uniform = shaderUniformsCache.getInt((Object)uniformName);
        } else {
            uniform = Uniform.m_85624_((int)program, (CharSequence)uniformName);
            shaderUniformsCache.put((Object)uniformName, uniform);
        }
        return uniform;
    }

    @API(status=API.Status.EXPERIMENTAL)
    public static void bindAdditionalTextures(int program, ResourceLocation ... textures) {
        for (int i = 0; i < textures.length; ++i) {
            ResourceLocation texture = textures[i];
            RenderSystem.activeTexture((int)(i + 33986));
            Minecraft.m_91087_().m_91097_().m_174784_(texture);
            ShaderPrograms.setUniform(program, "texture" + (i + 1), i + 2);
        }
        RenderSystem.activeTexture((int)33984);
    }
}

