/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;

public class CustomFormatFramebuffers {
    public static final String FORMAT_KEY = "satin:format";
    private static final ThreadLocal<TextureFormat> FORMAT = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @API(status=API.Status.EXPERIMENTAL)
    public static RenderTarget create(int width, int height, boolean useDepth, boolean getError, TextureFormat format) {
        try {
            FORMAT.set(format);
            TextureTarget textureTarget = new TextureTarget(width, height, useDepth, getError);
            return textureTarget;
        }
        finally {
            FORMAT.remove();
        }
    }

    public static void prepareCustomFormat(String formatString) {
        FORMAT.set(TextureFormat.decode(formatString));
    }

    @Nullable
    public static TextureFormat getCustomFormat() {
        return FORMAT.get();
    }

    public static void clearCustomFormat() {
        FORMAT.remove();
    }

    public static enum TextureFormat {
        RGBA8(32856),
        RGBA16(32859),
        RGBA16F(34842),
        RGBA32F(34836);

        public final int value;

        public static TextureFormat decode(String formatString) {
            return switch (formatString) {
                case "RGBA8" -> RGBA8;
                case "RGBA16" -> RGBA16;
                case "RGBA16F" -> RGBA16F;
                case "RGBA32F" -> RGBA32F;
                default -> throw new IllegalArgumentException("Unsupported texture format " + formatString);
            };
        }

        private TextureFormat(int value) {
            this.value = value;
        }
    }
}

