/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Window;
import javax.annotation.Nullable;
import ladysnake.satin.Satin;
import ladysnake.satin.api.managed.ManagedFramebuffer;
import ladysnake.satin.impl.RenderLayerSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderType;

public final class FramebufferWrapper
implements ManagedFramebuffer {
    private final RenderLayerSupplier renderLayerSupplier;
    private final String name;
    @Nullable
    private RenderTarget wrapped;

    FramebufferWrapper(String name) {
        this.name = name;
        this.renderLayerSupplier = RenderLayerSupplier.framebuffer(this.name + System.identityHashCode(this), () -> this.beginWrite(false), () -> Minecraft.m_91087_().m_91385_().m_83947_(false));
    }

    void findTarget(@Nullable PostChain shaderEffect) {
        if (shaderEffect == null) {
            this.wrapped = null;
        } else {
            this.wrapped = shaderEffect.m_110036_(this.name);
            if (this.wrapped == null) {
                Satin.LOGGER.warn("No target framebuffer found with name {} in shader {}", (Object)this.name, (Object)shaderEffect.m_110022_());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public RenderTarget getFramebuffer() {
        return this.wrapped;
    }

    @Override
    public void copyDepthFrom(RenderTarget buffer) {
        if (this.wrapped != null) {
            this.wrapped.m_83945_(buffer);
        }
    }

    @Override
    public void beginWrite(boolean updateViewport) {
        if (this.wrapped != null) {
            this.wrapped.m_83947_(updateViewport);
        }
    }

    @Override
    public void draw() {
        Window window = Minecraft.m_91087_().m_91268_();
        this.draw(window.m_85441_(), window.m_85442_(), true);
    }

    @Override
    public void draw(int width, int height, boolean disableBlend) {
        if (this.wrapped != null) {
            this.wrapped.m_83957_(width, height, disableBlend);
        }
    }

    @Override
    public void clear() {
        this.clear(Minecraft.f_91002_);
    }

    @Override
    public void clear(boolean swallowErrors) {
        if (this.wrapped != null) {
            this.wrapped.m_83954_(swallowErrors);
        }
    }

    @Override
    public RenderType getRenderLayer(RenderType baseLayer) {
        return this.renderLayerSupplier.getRenderLayer(baseLayer);
    }
}

