/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Set;
import java.util.function.Consumer;
import ladysnake.satin.Satin;
import ladysnake.satin.api.event.ResolutionChangeCallback;
import ladysnake.satin.api.managed.ManagedCoreShader;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.ShaderEffectManager;
import ladysnake.satin.impl.ResettableManagedCoreShader;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import ladysnake.satin.impl.ResettableManagedShaderEffect;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public final class ReloadableShaderEffectManager
implements ShaderEffectManager,
ResolutionChangeCallback {
    public static final ReloadableShaderEffectManager INSTANCE = new ReloadableShaderEffectManager();
    public static final ResourceLocation SHADER_RESOURCE_KEY = new ResourceLocation("dissolution:shaders");
    private final Set<ResettableManagedShaderBase<?>> managedShaders = new ReferenceOpenHashSet();

    @Override
    public ManagedShaderEffect manage(ResourceLocation location) {
        return this.manage(location, s -> {});
    }

    @Override
    public ManagedShaderEffect manage(ResourceLocation location, Consumer<ManagedShaderEffect> initCallback) {
        ResettableManagedShaderEffect ret = new ResettableManagedShaderEffect(location, initCallback);
        this.managedShaders.add(ret);
        return ret;
    }

    @Override
    public ManagedCoreShader manageCoreShader(ResourceLocation location) {
        return this.manageCoreShader(location, DefaultVertexFormat.f_85812_);
    }

    @Override
    public ManagedCoreShader manageCoreShader(ResourceLocation location, VertexFormat vertexFormat) {
        return this.manageCoreShader(location, vertexFormat, s -> {});
    }

    @Override
    public ManagedCoreShader manageCoreShader(ResourceLocation location, VertexFormat vertexFormat, Consumer<ManagedCoreShader> initCallback) {
        ResettableManagedCoreShader ret = new ResettableManagedCoreShader(location, vertexFormat, initCallback);
        this.managedShaders.add(ret);
        return ret;
    }

    @Override
    public void dispose(ManagedShaderEffect shader) {
        shader.release();
        this.managedShaders.remove(shader);
    }

    @Override
    public void dispose(ManagedCoreShader shader) {
        shader.release();
        this.managedShaders.remove(shader);
    }

    public void reload(ResourceProvider shaderResources) {
        for (ResettableManagedShaderBase<?> ss : this.managedShaders) {
            ss.initializeOrLog(shaderResources);
        }
    }

    @Override
    public void onResolutionChanged(int newWidth, int newHeight) {
        if (!Satin.areShadersDisabled() && !this.managedShaders.isEmpty()) {
            for (ResettableManagedShaderBase<?> ss : this.managedShaders) {
                if (!ss.isInitialized()) continue;
                ss.setup(newWidth, newHeight);
            }
        }
    }
}

