/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import ladysnake.satin.impl.RenderLayerDuplicator;
import ladysnake.satin.mixin.client.render.RenderPhaseAccessor;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import org.jetbrains.annotations.Nullable;

public class RenderLayerSupplier {
    private final Consumer<RenderType.CompositeState.CompositeStateBuilder> transform;
    private final Map<RenderType, RenderType> renderLayerCache = new HashMap<RenderType, RenderType>();
    private final String uniqueName;
    @Nullable
    private final VertexFormat vertexFormat;

    public static RenderLayerSupplier framebuffer(String name, Runnable setupState, Runnable cleanupState) {
        RenderStateShard.OutputStateShard target = new RenderStateShard.OutputStateShard(name + "_target", setupState, cleanupState);
        return new RenderLayerSupplier(name, builder -> builder.m_110675_(target));
    }

    public static RenderLayerSupplier shader(String name, VertexFormat vertexFormat, Supplier<ShaderInstance> shaderSupplier) {
        RenderStateShard shader = Helper.makeShader(shaderSupplier);
        return new RenderLayerSupplier(name, vertexFormat, builder -> Helper.applyShader(builder, shader));
    }

    public RenderLayerSupplier(String name, Consumer<RenderType.CompositeState.CompositeStateBuilder> transformer) {
        this(name, null, transformer);
    }

    public RenderLayerSupplier(String name, @Nullable VertexFormat vertexFormat, Consumer<RenderType.CompositeState.CompositeStateBuilder> transformer) {
        this.uniqueName = name;
        this.vertexFormat = vertexFormat;
        this.transform = transformer;
    }

    public RenderType getRenderLayer(RenderType baseLayer) {
        RenderType existing = this.renderLayerCache.get(baseLayer);
        if (existing != null) {
            return existing;
        }
        String newName = ((RenderPhaseAccessor)baseLayer).getName() + "_" + this.uniqueName;
        RenderType newLayer = RenderLayerDuplicator.copy(baseLayer, newName, this.vertexFormat, this.transform);
        this.renderLayerCache.put(baseLayer, newLayer);
        return newLayer;
    }

    private static class Helper
    extends RenderStateShard {
        public static RenderStateShard makeShader(Supplier<ShaderInstance> shader) {
            return new RenderStateShard.ShaderStateShard(shader);
        }

        public static void applyShader(RenderType.CompositeState.CompositeStateBuilder builder, RenderStateShard shader) {
            builder.m_173292_((RenderStateShard.ShaderStateShard)shader);
        }

        private Helper(String name, Runnable beginAction, Runnable endAction) {
            super(name, beginAction, endAction);
        }
    }
}

