/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import ladysnake.satin.Satin;
import ladysnake.satin.api.managed.ManagedCoreShader;
import ladysnake.satin.api.managed.uniform.SamplerUniform;
import ladysnake.satin.impl.ManagedSamplerUniformV1;
import ladysnake.satin.impl.ManagedUniformBase;
import ladysnake.satin.impl.RenderLayerSupplier;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import net.fabricmc.fabric.impl.client.rendering.FabricShaderProgram;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;

public final class ResettableManagedCoreShader
extends ResettableManagedShaderBase<ShaderInstance>
implements ManagedCoreShader {
    private final Consumer<ManagedCoreShader> initCallback;
    private final RenderLayerSupplier renderLayerSupplier;
    private final VertexFormat vertexFormat;
    private final Map<String, ManagedSamplerUniformV1> managedSamplers = new HashMap<String, ManagedSamplerUniformV1>();

    public ResettableManagedCoreShader(ResourceLocation location, VertexFormat vertexFormat, Consumer<ManagedCoreShader> initCallback) {
        super(location);
        this.vertexFormat = vertexFormat;
        this.initCallback = initCallback;
        this.renderLayerSupplier = RenderLayerSupplier.shader(String.format("%s_%d", location, System.identityHashCode(this)), vertexFormat, this::getProgram);
    }

    @Override
    protected ShaderInstance parseShader(ResourceProvider resourceManager, Minecraft mc, ResourceLocation location) throws IOException {
        return new FabricShaderProgram(resourceManager, this.getLocation(), this.vertexFormat);
    }

    @Override
    public void setup(int newWidth, int newHeight) {
        Preconditions.checkNotNull((Object)((ShaderInstance)this.shader));
        for (ManagedUniformBase uniform : this.getManagedUniforms()) {
            this.setupUniform(uniform, (ShaderInstance)this.shader);
        }
        this.initCallback.accept(this);
    }

    @Override
    public ShaderInstance getProgram() {
        return (ShaderInstance)this.shader;
    }

    @Override
    public RenderType getRenderLayer(RenderType baseLayer) {
        return this.renderLayerSupplier.getRenderLayer(baseLayer);
    }

    @Override
    protected boolean setupUniform(ManagedUniformBase uniform, ShaderInstance shader) {
        return uniform.findUniformTarget(shader);
    }

    @Override
    public SamplerUniform findSampler(String samplerName) {
        return this.manageUniform(this.managedSamplers, ManagedSamplerUniformV1::new, samplerName, "sampler");
    }

    @Override
    protected void logInitError(IOException e) {
        Satin.LOGGER.error("Could not create shader program {}", (Object)this.getLocation(), (Object)e);
    }
}

