/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.satin.impl;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import ladysnake.satin.Satin;
import ladysnake.satin.api.managed.ManagedFramebuffer;
import ladysnake.satin.api.managed.ManagedShaderEffect;
import ladysnake.satin.api.managed.uniform.SamplerUniformV2;
import ladysnake.satin.api.util.ShaderPrograms;
import ladysnake.satin.impl.FramebufferWrapper;
import ladysnake.satin.impl.ManagedSamplerUniformV2;
import ladysnake.satin.impl.ManagedUniformBase;
import ladysnake.satin.impl.ResettableManagedShaderBase;
import ladysnake.satin.mixin.client.AccessiblePassesShaderEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apiguardian.api.API;
import org.joml.Matrix4f;

public final class ResettableManagedShaderEffect
extends ResettableManagedShaderBase<PostChain>
implements ManagedShaderEffect {
    private final Consumer<ManagedShaderEffect> initCallback;
    private final Map<String, FramebufferWrapper> managedTargets;
    private final Map<String, ManagedSamplerUniformV2> managedSamplers = new HashMap<String, ManagedSamplerUniformV2>();

    @API(status=API.Status.INTERNAL)
    public ResettableManagedShaderEffect(ResourceLocation location, Consumer<ManagedShaderEffect> initCallback) {
        super(location);
        this.initCallback = initCallback;
        this.managedTargets = new HashMap<String, FramebufferWrapper>();
    }

    @Override
    @Nullable
    public PostChain getShaderEffect() {
        return this.getShaderOrLog();
    }

    @Override
    public void initialize() throws IOException {
        super.initialize((ResourceProvider)Minecraft.m_91087_().m_91098_());
    }

    @Override
    protected PostChain parseShader(ResourceProvider resourceFactory, Minecraft mc, ResourceLocation location) throws IOException {
        return new PostChain(mc.m_91097_(), mc.m_91098_(), mc.m_91385_(), location);
    }

    @Override
    public void setup(int windowWidth, int windowHeight) {
        Preconditions.checkNotNull((Object)((PostChain)this.shader));
        ((PostChain)this.shader).m_110025_(windowWidth, windowHeight);
        for (ManagedUniformBase uniform : this.getManagedUniforms()) {
            this.setupUniform(uniform, (PostChain)this.shader);
        }
        for (FramebufferWrapper buf : this.managedTargets.values()) {
            buf.findTarget((PostChain)this.shader);
        }
        this.initCallback.accept(this);
    }

    @Override
    public void render(float tickDelta) {
        PostChain sg = this.getShaderEffect();
        if (sg != null) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            sg.m_110023_(tickDelta);
            Minecraft.m_91087_().m_91385_().m_83947_(true);
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableDepthTest();
        }
    }

    @Override
    public ManagedFramebuffer getTarget(String name) {
        return this.managedTargets.computeIfAbsent(name, n -> {
            FramebufferWrapper ret = new FramebufferWrapper((String)n);
            if (this.shader != null) {
                ret.findTarget((PostChain)this.shader);
            }
            return ret;
        });
    }

    @Override
    public void setUniformValue(String uniformName, int value) {
        this.findUniform1i(uniformName).set(value);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1) {
        this.findUniform2i(uniformName).set(value0, value1);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1, int value2) {
        this.findUniform3i(uniformName).set(value0, value1, value2);
    }

    @Override
    public void setUniformValue(String uniformName, int value0, int value1, int value2, int value3) {
        this.findUniform4i(uniformName).set(value0, value1, value2, value3);
    }

    @Override
    public void setUniformValue(String uniformName, float value) {
        this.findUniform1f(uniformName).set(value);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1) {
        this.findUniform2f(uniformName).set(value0, value1);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1, float value2) {
        this.findUniform3f(uniformName).set(value0, value1, value2);
    }

    @Override
    public void setUniformValue(String uniformName, float value0, float value1, float value2, float value3) {
        this.findUniform4f(uniformName).set(value0, value1, value2, value3);
    }

    @Override
    public void setUniformValue(String uniformName, Matrix4f value) {
        this.findUniformMat4(uniformName).set(value);
    }

    @Override
    public void setSamplerUniform(String samplerName, AbstractTexture texture) {
        this.findSampler(samplerName).set(texture);
    }

    @Override
    public void setSamplerUniform(String samplerName, RenderTarget textureFbo) {
        this.findSampler(samplerName).set(textureFbo);
    }

    @Override
    public void setSamplerUniform(String samplerName, int textureName) {
        this.findSampler(samplerName).set(textureName);
    }

    @Override
    public SamplerUniformV2 findSampler(String samplerName) {
        return this.manageUniform(this.managedSamplers, ManagedSamplerUniformV2::new, samplerName, "sampler");
    }

    @Override
    public void setupDynamicUniforms(Runnable dynamicSetBlock) {
        this.setupDynamicUniforms(0, dynamicSetBlock);
    }

    @Override
    public void setupDynamicUniforms(int index, Runnable dynamicSetBlock) {
        AccessiblePassesShaderEffect sg = (AccessiblePassesShaderEffect)this.getShaderEffect();
        if (sg != null) {
            EffectInstance sm = sg.getPasses().get(index).m_110074_();
            ShaderPrograms.useShader(sm.m_108943_());
            dynamicSetBlock.run();
            ShaderPrograms.useShader(0);
        }
    }

    @Override
    protected boolean setupUniform(ManagedUniformBase uniform, PostChain shader) {
        return uniform.findUniformTargets(((AccessiblePassesShaderEffect)shader).getPasses());
    }

    @Override
    protected void logInitError(IOException e) {
        Satin.LOGGER.error("Could not create screen shader {}", (Object)this.getLocation(), (Object)e);
    }

    @Nullable
    private PostChain getShaderOrLog() {
        if (!this.isInitialized() && !this.isErrored()) {
            this.initializeOrLog((ResourceProvider)Minecraft.m_91087_().m_91098_());
        }
        return (PostChain)this.shader;
    }
}

