/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;

public class TreeCache {
    private Queue<BlockPos> woodCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).m_123331_(new Vec3i(((BlockPos)value).m_123341_(), current.m_123342_(), ((BlockPos)value).m_123343_()))).reversed());
    private Queue<BlockPos> leavesCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).m_123331_(new Vec3i(current.m_123341_(), ((BlockPos)value).m_123342_(), current.m_123343_()))).reversed());
    private Level world;
    private BlockPos current;

    public TreeCache(Level world, BlockPos current) {
        this.world = world;
        this.current = current;
    }

    public List<ItemStack> chop(Queue<BlockPos> cache, boolean shear) {
        BlockPos p = cache.peek();
        NonNullList stacks = NonNullList.m_122779_();
        if (BlockUtils.isLeaves(this.world, p) || BlockUtils.isLog(this.world, p)) {
            BlockState s = this.world.m_8055_(p);
            if (s.m_60734_() instanceof IForgeShearable && shear) {
                stacks.addAll((Collection)((IForgeShearable)s.m_60734_()).onSheared(null, new ItemStack((ItemLike)Items.f_42574_), this.world, p, 0));
            } else {
                stacks.addAll(BlockUtils.getBlockDrops(this.world, p));
            }
            this.world.m_46597_(p, Blocks.f_50016_.m_49966_());
        }
        cache.poll();
        return stacks;
    }

    public Queue<BlockPos> getWoodCache() {
        return this.woodCache;
    }

    public Queue<BlockPos> getLeavesCache() {
        return this.leavesCache;
    }

    public void scanForTreeBlockSection() {
        BlockPos yCheck = this.getHighestBlock(this.current);
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)yCheck.m_7918_(1, 0, 0), (BlockPos)yCheck.m_7918_(0, 0, 1))) {
            BlockPos tempHigh = this.getHighestBlock(pos.m_7949_());
            if (tempHigh.m_123342_() <= yCheck.m_123342_()) continue;
            yCheck = tempHigh;
        }
        yCheck = yCheck.m_7918_(0, -Math.min(20, yCheck.m_123342_() - this.current.m_123342_()), 0);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        Stack<BlockPos> tree = new Stack<BlockPos>();
        BlockPos test = new BlockPos(this.current.m_123341_(), yCheck.m_123342_(), this.current.m_123343_());
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)test.m_7918_(1, 0, 0), (BlockPos)test.m_7918_(0, 0, 1))) {
            tree.push(pos.m_7949_());
        }
        while (!tree.isEmpty()) {
            BlockPos checking = (BlockPos)tree.pop();
            if (!BlockUtils.isLeaves(this.world, checking) && !BlockUtils.isLog(this.world, checking)) continue;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)checking.m_7918_(-1, 0, -1), (BlockPos)checking.m_7918_(1, 1, 1))) {
                BlockPos blockPos = pos.m_7949_();
                if (this.world.m_46859_(blockPos) || checkedPositions.contains(blockPos) || blockPos.m_123333_(new Vec3i(this.current.m_123341_(), this.current.m_123342_(), this.current.m_123343_())) > 100) continue;
                if (BlockUtils.isLeaves(this.world, blockPos)) {
                    tree.push(blockPos);
                    this.leavesCache.add(blockPos);
                    checkedPositions.add(blockPos);
                    continue;
                }
                if (!BlockUtils.isLog(this.world, blockPos)) continue;
                tree.push(blockPos);
                this.woodCache.add(blockPos);
                checkedPositions.add(blockPos);
            }
        }
    }

    public BlockPos getHighestBlock(BlockPos position) {
        while (!this.world.m_46859_(position.m_7494_()) && (BlockUtils.isLog(this.world, position.m_7494_()) || BlockUtils.isLeaves(this.world, position.m_7494_()))) {
            position = position.m_7494_();
        }
        return position;
    }
}

