/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.Rect2i;

public class VerticalButtonBar
implements ICompositeWidget {
    private static final int VERTICAL_SPACING = 4;
    private static final int MARGIN = 2;
    private final List<Button> buttons = new ArrayList<Button>();
    private Point screenOrigin = Point.ZERO;
    private Rect2i bounds = new Rect2i(0, 0, 0, 0);
    private Point position;

    public void add(Button button) {
        this.buttons.add(button);
    }

    @Override
    public void setPosition(Point position) {
        this.position = position;
    }

    @Override
    public void setSize(int width, int height) {
    }

    @Override
    public Rect2i getBounds() {
        return this.bounds;
    }

    @Override
    public void updateBeforeRender() {
        int currentY = this.position.getY() + 2;
        int maxWidth = 0;
        for (Button button : this.buttons) {
            if (!button.f_93624_) continue;
            button.m_252865_(this.screenOrigin.getX() + this.position.getX() - 2 - button.m_5711_());
            button.m_253211_(this.screenOrigin.getY() + currentY);
            currentY += button.m_93694_() + 4;
            maxWidth = Math.max(button.m_5711_(), maxWidth);
        }
        if (maxWidth == 0) {
            this.bounds = new Rect2i(0, 0, 0, 0);
        } else {
            int boundX = this.position.getX() - maxWidth - 4;
            int boundY = this.position.getY();
            this.bounds = new Rect2i(boundX, boundY, maxWidth + 4, currentY - boundY);
        }
    }

    @Override
    public void populateScreen(Consumer<AbstractWidget> addWidget, Rect2i bounds, AEBaseScreen<?> screen) {
        this.screenOrigin = Point.fromTopLeft(bounds);
        for (Button button : this.buttons) {
            if (button.m_93696_()) {
                button.m_93692_(false);
            }
            addWidget.accept((AbstractWidget)button);
        }
    }
}

