/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class IntegerOption
extends BaseOption {
    private final int defaultValue;
    private final int minValue;
    private final int maxValue;
    private int currentValue;

    public IntegerOption(ConfigSection parent, String id, String comment, int defaultValue, int minValue, int maxValue) {
        super(parent, id, comment);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public int get() {
        return this.currentValue;
    }

    public void set(int value) {
        if (value == this.currentValue) {
            return;
        }
        this.checkValue(value);
        this.currentValue = value;
        this.parent.markDirty();
    }

    private void checkValue(int value) {
        if (value < this.minValue || value > this.maxValue) {
            StringBuilder rangeDescription = new StringBuilder();
            if (this.minValue != Integer.MIN_VALUE) {
                rangeDescription.append("min: ").append(this.minValue);
            }
            if (this.maxValue != Integer.MAX_VALUE) {
                if (rangeDescription.length() > 0) {
                    rangeDescription.append(", ");
                }
                rangeDescription.append("max: ").append(this.maxValue);
            }
            throw new ConfigValidationException(this, "Value out of range: " + value + " (" + String.valueOf(rangeDescription) + ")");
        }
    }

    @Override
    protected JsonElement write() {
        return new JsonPrimitive((Number)this.currentValue);
    }

    @Override
    protected void read(JsonElement element) {
        int value;
        if (!element.isJsonPrimitive()) {
            throw new ConfigValidationException(this, "Expected a JSON primitive, but found: " + String.valueOf(element));
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isNumber()) {
            throw new ConfigValidationException(this, "Expected a JSON number, but found: " + String.valueOf(primitive));
        }
        try {
            value = primitive.getAsInt();
        }
        catch (NumberFormatException ignored) {
            throw new ConfigValidationException(this, "Expected an integer value, but found: " + String.valueOf(primitive));
        }
        this.checkValue(value);
        this.currentValue = value;
    }

    @Override
    public boolean isDifferentFromDefault() {
        return this.currentValue != this.defaultValue;
    }

    @Override
    public String getDefaultAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(this.currentValue);
    }
}

