/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.stacks.AEKey;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.sync.BasePacket;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AssemblerAnimationPacket
extends BasePacket {
    private final BlockPos pos;
    public final byte rate;
    public final AEKey what;

    public AssemblerAnimationPacket(FriendlyByteBuf stream) {
        this.pos = stream.m_130135_();
        this.rate = stream.readByte();
        this.what = AEKey.readKey(stream);
    }

    public AssemblerAnimationPacket(BlockPos pos, byte rate, AEKey what) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        this.pos = pos;
        data.m_130064_(this.pos);
        this.rate = rate;
        data.writeByte((int)this.rate);
        AEKey.writeKey(data, what);
        this.what = what;
        this.configureWrite(data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(Player player) {
        BlockEntity te = player.m_20193_().m_7702_(this.pos);
        if (te instanceof MolecularAssemblerBlockEntity) {
            MolecularAssemblerBlockEntity ma = (MolecularAssemblerBlockEntity)te;
            ma.setAnimationStatus(new AssemblerAnimationStatus(this.rate, this.what.wrapForDisplayOrFilter()));
        }
    }
}

