/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.locator;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.core.AELog;
import appeng.menu.locator.MenuLocator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

record MenuItemLocator(int itemIndex, @Nullable BlockPos blockPos) implements MenuLocator
{
    @Override
    @Nullable
    public <T> T locate(Player player, Class<T> hostInterface) {
        Item item;
        ItemStack it = player.m_150109_().m_8020_(this.itemIndex);
        if (!it.m_41619_() && (item = it.m_41720_()) instanceof IMenuItem) {
            IMenuItem guiItem = (IMenuItem)item;
            ItemMenuHost menuHost = guiItem.getMenuHost(player, this.itemIndex, it, this.blockPos);
            if (hostInterface.isInstance(menuHost)) {
                return hostInterface.cast(menuHost);
            }
            if (menuHost != null) {
                AELog.warn("Item in slot %d of %s did not create a compatible menu of type %s: %s", this.itemIndex, player, hostInterface, menuHost);
            }
        } else {
            AELog.warn("Item in slot %d of %s is not an IMenuItem: %s", this.itemIndex, player, it);
        }
        return null;
    }

    public void writeToPacket(FriendlyByteBuf buf) {
        buf.writeInt(this.itemIndex);
        buf.writeBoolean(this.blockPos != null);
        if (this.blockPos != null) {
            buf.m_130064_(this.blockPos);
        }
    }

    public static MenuItemLocator readFromPacket(FriendlyByteBuf buf) {
        int itemIndex = buf.readInt();
        BlockPos blockPos = null;
        if (buf.readBoolean()) {
            blockPos = buf.m_130135_();
        }
        return new MenuItemLocator(itemIndex, blockPos);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("MenuItem");
        result.append('{');
        result.append("slot=").append(this.itemIndex);
        if (this.blockPos != null) {
            result.append(',').append("pos=").append(this.blockPos);
        }
        result.append('}');
        return result.toString();
    }
}

