/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

final class VoxelShapeCache {
    private static final LoadingCache<List<AABB>, VoxelShape> CACHE = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<List<AABB>, VoxelShape>(){

        public VoxelShape load(List<AABB> key) {
            return VoxelShapeCache.create(key);
        }
    });

    private VoxelShapeCache() {
    }

    public static VoxelShape get(List<AABB> boxes) {
        return (VoxelShape)CACHE.getUnchecked(boxes);
    }

    private static VoxelShape create(List<AABB> boxes) {
        int i;
        if (boxes.isEmpty()) {
            return Shapes.m_83040_();
        }
        VoxelShape shape = Shapes.m_83064_((AABB)boxes.get(i));
        for (i = 0; i < boxes.size(); ++i) {
            AABB box = boxes.get(i);
            shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)box), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape.m_83296_();
    }
}

