/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.common.blocks;

import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;
import net.xalcon.torchmaster.common.ModCaps;
import net.xalcon.torchmaster.common.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.common.network.ModMessageHandler;
import net.xalcon.torchmaster.common.network.volume.VolumeDisplayMessage;

public class EntityBlockingLightBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private Function<BlockPos, String> keyFactory;
    private Function<BlockPos, IEntityBlockingLight> lightFactory;
    private float flameOffsetY;
    private final VoxelShape shape;
    private Supplier<Integer> range;

    public EntityBlockingLightBlock(BlockBehaviour.Properties properties, Function<BlockPos, String> keyFactory, Function<BlockPos, IEntityBlockingLight> lightFactory, float flameOffsetY, VoxelShape shape, Supplier<Integer> rangeSupplier) {
        super(properties);
        this.keyFactory = keyFactory;
        this.lightFactory = lightFactory;
        this.flameOffsetY = flameOffsetY;
        this.shape = shape;
        this.range = rangeSupplier;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        return this.shape;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.m_5776_()) {
            boolean show = !player.m_6144_();
            int color = 10551072;
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item item = itemStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem item2 = (DyeItem)item;
                color = item2.m_41089_().m_41071_();
            }
            player.m_5661_((Component)Component.m_237115_((String)(show ? "torchmaster.torch_volume.on_show" : "torchmaster.torch_volume.on_hide")), true);
            VolumeDisplayMessage msg = VolumeDisplayMessage.create((Vec3i)pos, this.range.get(), color, show, show);
            ModMessageHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)msg);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        double d0 = (double)pos.m_123341_() + 0.5;
        double d1 = (double)pos.m_123342_() + (double)this.flameOffsetY;
        double d2 = (double)pos.m_123343_() + 0.5;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0, d1, d2, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, world, pos, oldState, moving);
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.registerLight(this.keyFactory.apply(pos), this.lightFactory.apply(pos)));
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        world.getCapability(ModCaps.TEB_REGISTRY).ifPresent(reg -> reg.unregisterLight(this.keyFactory.apply(pos)));
        super.m_6810_(state, world, pos, oldState, moving);
    }
}

