/*
 * Decompiled with CFR 0.152.
 */
package ru.markthelark.spiceofoverhaul.items;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.extensions.IForgeItem;
import org.jetbrains.annotations.Nullable;
import ru.markthelark.spiceofoverhaul.util.FoodHashAccessor;

public class FoodBag
extends BundleItem
implements IForgeItem {
    public FoodBag(Item.Properties pProperties) {
        super(pProperties);
    }

    public ItemStack m_5922_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Items")) {
            return pStack;
        }
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        ItemStack itemToUse = FoodBag.nextToEat(pStack, pEntityLiving);
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            FoodData foodData = player.m_36324_();
            if (foodData instanceof FoodHashAccessor) {
                ((FoodHashAccessor)foodData).eat(itemToUse.m_41720_(), itemToUse, (LivingEntity)player);
            } else {
                foodData.eat(itemToUse.m_41720_(), itemToUse, (LivingEntity)player);
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)itemToUse.m_41720_()));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12321_, SoundSource.PLAYERS, 0.5f, player.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        CompoundTag compoundtag1 = new CompoundTag();
        itemToUse.m_41739_(compoundtag1);
        int index = listtag.indexOf((Object)compoundtag1);
        listtag.remove(index);
        if (itemToUse.m_41613_() > 1) {
            itemToUse.m_41774_(1);
            CompoundTag compoundtag2 = new CompoundTag();
            itemToUse.m_41739_(compoundtag2);
            listtag.add(index, (Tag)compoundtag2);
        }
        compoundtag.m_128473_("Items");
        compoundtag.m_128365_("Items", (Tag)listtag);
        pStack.m_41751_(compoundtag);
        return pStack;
    }

    public int m_8105_(ItemStack pStack) {
        return 10;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.EAT;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pUsedHand) {
        ItemStack itemstack = player.m_21120_(pUsedHand);
        ItemStack itemToUse = FoodBag.nextToEat(itemstack, (LivingEntity)player);
        if (itemToUse == null) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        FoodProperties foodproperties = itemToUse.getFoodProperties((LivingEntity)player);
        if (foodproperties != null) {
            if (player.m_36391_(foodproperties.m_38747_())) {
                player.m_6672_(pUsedHand);
                return InteractionResultHolder.m_19090_((Object)itemstack);
            }
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(pUsedHand));
    }

    public static ItemStack nextToEat(ItemStack itemStack, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return null;
        }
        Player player = (Player)entity;
        CompoundTag compoundtag = itemStack.m_41784_();
        FoodData foodData = player.m_36324_();
        if (!(foodData instanceof FoodHashAccessor) || !compoundtag.m_128441_("Items")) {
            return null;
        }
        HashMap<String, Integer> foodHash = ((FoodHashAccessor)foodData).getFoodHash();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag listtag = compoundtag.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag1 = listtag.m_128728_(i);
            ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag1);
            items.add(itemstack);
        }
        ItemStack itemToUse = null;
        int eaten = 21;
        for (ItemStack item : items) {
            String itemString = item.m_41720_().getCreatorModId(item) + ":" + item.m_41720_().toString().replace(" ", "");
            if (foodHash.get(itemString) == null && item.m_41614_()) {
                itemToUse = item;
                break;
            }
            if (foodHash.get(itemString) > eaten) continue;
            itemToUse = item;
            eaten = foodHash.get(itemString);
        }
        return itemToUse;
    }

    public boolean m_142207_(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        ItemStack itemStack = pSlot.m_7993_();
        if (itemStack.m_41619_() || itemStack.m_41614_()) {
            return super.m_142207_(pStack, pSlot, pAction, pPlayer);
        }
        return false;
    }

    public boolean m_142305_(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pOther.m_41619_() || pOther.m_41614_()) {
            return super.m_142305_(pStack, pOther, pSlot, pAction, pPlayer, pAccess);
        }
        return false;
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        ItemStack itemToUse = FoodBag.nextToEat(stack, entity);
        if (itemToUse == null) {
            return null;
        }
        return itemToUse.getFoodProperties(entity);
    }
}

