/*
 * Decompiled with CFR 0.152.
 */
package ru.markthelark.spiceofoverhaul.mixin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.markthelark.spiceofoverhaul.Config;
import ru.markthelark.spiceofoverhaul.SpiceOfOverhaul;
import ru.markthelark.spiceofoverhaul.util.FoodHashAccessor;
import ru.markthelark.spiceofoverhaul.util.FormulaProvider;

@Mixin(value={FoodData.class})
public abstract class FoodDataMixin
implements FoodHashAccessor {
    @Shadow
    private int f_38700_;
    @Shadow
    private int f_38696_;
    @Shadow
    private float f_38698_;
    @Shadow
    private float f_38697_;
    @Shadow
    private int f_38699_;
    @Unique
    public final int historyLength = Config.historyLength;
    @Unique
    private LinkedList<String> foodQueue = new LinkedList();
    @Unique
    public HashMap<String, Integer> foodHash = new HashMap();

    @Override
    @Unique
    public HashMap<String, Integer> getFoodHash() {
        return this.foodHash;
    }

    @Override
    @Unique
    public LinkedList<String> getFoodQueue() {
        return this.foodQueue;
    }

    @Override
    @Unique
    public int getFoodHistory() {
        return this.historyLength;
    }

    @Override
    @Unique
    public String getFoodQueueString() {
        String saveFoodQueue = this.foodQueue.toString().replace(" ", "");
        saveFoodQueue = saveFoodQueue.replace("[", "");
        saveFoodQueue = saveFoodQueue.replace("]", "");
        return saveFoodQueue;
    }

    @Shadow
    public abstract void m_38707_(int var1, float var2);

    @Override
    public void eat(Item item, ItemStack itemStack, LivingEntity entity) {
        if (Config.enableSOLModule) {
            if (item.m_41472_()) {
                FoodProperties foodproperties = itemStack.getFoodProperties(entity);
                String itemString = itemStack.m_41720_().getCreatorModId(itemStack) + ":" + itemStack.m_41720_().toString().replace(" ", "");
                if (!this.foodQueue.contains(itemString)) {
                    this.foodHash.put(itemString, 0);
                }
                int eaten = this.foodHash.get(itemString);
                this.m_38707_(FormulaProvider.FormulaHunger(foodproperties.m_38744_(), foodproperties.m_38745_(), eaten), FormulaProvider.FormulaSaturation(foodproperties.m_38744_(), foodproperties.m_38745_(), eaten));
                if (this.foodQueue.size() >= this.historyLength) {
                    String elem = this.foodQueue.pollFirst();
                    this.foodHash.put(elem, this.foodHash.get(elem) - 1);
                }
                this.foodHash.put(itemString, this.foodHash.get(itemString) + 1);
                this.foodQueue.add(itemString);
                if (Config.enableWellFed) {
                    int duration = 0;
                    if ((int)((double)foodproperties.m_38744_() * Math.pow(0.7, eaten)) >= 14) {
                        duration = 9600;
                    } else if ((int)((double)foodproperties.m_38744_() * Math.pow(0.7, eaten)) >= 10) {
                        duration = 4800;
                    } else if ((int)((double)foodproperties.m_38744_() * Math.pow(0.7, eaten)) >= 7) {
                        duration = 2400;
                    } else if ((int)((double)foodproperties.m_38744_() * Math.pow(0.7, eaten)) >= 4) {
                        duration = 800;
                    }
                    if (duration > 0) {
                        entity.m_7292_(new MobEffectInstance((MobEffect)SpiceOfOverhaul.WELLFED.get(), duration, 0));
                    }
                }
            }
        } else if (item.m_41472_()) {
            FoodProperties foodproperties = itemStack.getFoodProperties(entity);
            this.m_38707_(foodproperties.m_38744_(), foodproperties.m_38745_());
            if (Config.enableWellFed) {
                int duration = 0;
                if (foodproperties.m_38744_() >= 14) {
                    duration = 9600;
                } else if (foodproperties.m_38744_() >= 10) {
                    duration = 4800;
                } else if (foodproperties.m_38744_() >= 7) {
                    duration = 2400;
                } else if (foodproperties.m_38744_() >= 4) {
                    duration = 800;
                }
                if (duration > 0) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)SpiceOfOverhaul.WELLFED.get(), duration, 0));
                }
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void addAdditionalSaveData(CompoundTag p_38720_, CallbackInfo info) {
        String saveFoodQueue = this.foodQueue.toString().replace(" ", "");
        saveFoodQueue = saveFoodQueue.replace("[", "");
        saveFoodQueue = saveFoodQueue.replace("]", "");
        p_38720_.m_128359_("spiceofoverhaul:foodQueue", saveFoodQueue);
        p_38720_.m_128359_("debug", this.foodHash.toString());
    }

    @Inject(at={@At(value="TAIL")}, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    public void readAdditionalSaveData(CompoundTag p_38716_, CallbackInfo info) {
        if (p_38716_.m_128441_("spiceofoverhaul:foodQueue")) {
            String saveFoodQueue = p_38716_.m_128461_("spiceofoverhaul:foodQueue");
            LinkedList<String> foodList = new LinkedList<String>(Arrays.asList(saveFoodQueue.split(",")));
            int length = foodList.size();
            for (int i = 0; i < length - this.historyLength + 1; ++i) {
                foodList.removeLast();
            }
            this.foodQueue = foodList;
            HashMap<String, Integer> hash = new HashMap<String, Integer>();
            for (String element : foodList) {
                int frequency = hash.get(element) == null ? 1 : (Integer)hash.get(element) + 1;
                hash.put(element, frequency);
            }
            this.foodHash = hash;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"needsFood"}, cancellable=true)
    public void onNeedsFood(CallbackInfoReturnable<Boolean> info) {
        info.setReturnValue((Object)(this.f_38696_ < 20 || Config.foodEatableAnyway ? 1 : 0));
    }

    @Inject(at={@At(value="HEAD")}, method={"tick(Lnet/minecraft/world/entity/player/Player;)V"}, cancellable=true)
    private void injected(Player p_38711_, CallbackInfo info) {
        if (Config.regenRework) {
            info.cancel();
            Difficulty difficulty = p_38711_.m_9236_().m_46791_();
            this.f_38700_ = this.f_38696_;
            if (this.f_38698_ > 4.0f) {
                this.f_38698_ -= 4.0f;
                if (this.f_38697_ > 0.0f) {
                    this.f_38697_ = Math.max(this.f_38697_ - 1.0f, 0.0f);
                } else if (difficulty != Difficulty.PEACEFUL) {
                    this.f_38696_ = Math.max(this.f_38696_ - 1, 0);
                }
            }
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("spiceofoverhaul", "wellfed"));
            float wellFedModifier = 1.0f;
            if (p_38711_.m_21023_(effect)) {
                wellFedModifier = 0.66f;
            }
            float difficultyModifier = 1.0f;
            if (difficulty == Difficulty.HARD) {
                difficultyModifier *= 1.5f;
            } else if (difficulty.m_19028_() <= 1) {
                difficultyModifier *= 0.75f;
            }
            float modifier = 20 / Math.max(this.f_38696_, 10);
            modifier *= p_38711_.m_21233_() / Math.max(p_38711_.m_21223_(), 10.0f);
            modifier *= difficultyModifier;
            modifier *= wellFedModifier;
            modifier = Math.min(modifier, 4.0f);
            boolean flag = p_38711_.m_9236_().m_46469_().m_46207_(GameRules.f_46139_);
            if (flag && this.f_38696_ >= 7 && p_38711_.m_36325_()) {
                ++this.f_38699_;
                if (this.f_38699_ >= Math.round(60.0f * modifier)) {
                    p_38711_.m_5634_(1.0f);
                    if (!Config.regenHungerOnly && this.f_38697_ > 0.0f) {
                        this.f_38697_ = Math.max(this.f_38697_ - 1.0f, 0.0f);
                    } else {
                        this.f_38696_ = Math.max(this.f_38696_ - 1, 0);
                        this.f_38699_ = 0;
                    }
                }
            } else if (this.f_38696_ <= 0) {
                ++this.f_38699_;
                if (this.f_38699_ >= 40) {
                    p_38711_.m_6469_(p_38711_.m_269291_().m_269064_(), 1.0f);
                    this.f_38699_ = 0;
                }
            } else {
                this.f_38699_ = 0;
            }
        }
    }

    @Override
    @Unique
    public void setFoodQueue(String saveFoodQueue) {
        LinkedList<String> foodList = new LinkedList<String>(Arrays.asList(saveFoodQueue.split(",")));
        int length = foodList.size();
        for (int i = 0; i < length - this.historyLength + 1; ++i) {
            foodList.removeLast();
        }
        this.foodQueue = foodList;
        HashMap<String, Integer> hash = new HashMap<String, Integer>();
        for (String element : foodList) {
            int frequency = hash.get(element) == null ? 1 : (Integer)hash.get(element) + 1;
            hash.put(element, frequency);
        }
        this.foodHash = hash;
    }
}

