/*
 * Decompiled with CFR 0.152.
 */
package ru.markthelark.spiceofoverhaul.mixin;

import com.mojang.datafixers.util.Pair;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.markthelark.spiceofoverhaul.Config;
import squeek.appleskin.api.food.FoodValues;
import squeek.appleskin.helpers.FoodHelper;

@Mixin(value={FoodHelper.class})
public class FoodHelperMixin {
    @Inject(method={"getEstimatedHealthIncrement(Lnet/minecraft/world/item/ItemStack;Lsqueek/appleskin/api/food/FoodValues;Lnet/minecraft/world/entity/player/Player;)F"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void getEstimatedHealthIncrement(ItemStack itemStack, FoodValues modifiedFoodValues, Player player, CallbackInfoReturnable<Float> cir) {
        if (!FoodHelper.isFood((ItemStack)itemStack, (Player)player) || !Config.regenHungerOnly) {
            return;
        }
        if (!player.m_36325_()) {
            return;
        }
        FoodData stats = player.m_36324_();
        Level world = player.m_20193_();
        int foodLevel = Math.min(stats.m_38702_() + modifiedFoodValues.hunger, 20);
        float healthIncrement = 0.0f;
        if ((float)foodLevel >= 7.0f && world != null && world.m_46469_().m_46207_(GameRules.f_46139_)) {
            healthIncrement = foodLevel - 6;
        }
        for (Pair effect : itemStack.m_41720_().getFoodProperties(itemStack, (LivingEntity)player).m_38749_()) {
            MobEffectInstance effectInstance = (MobEffectInstance)effect.getFirst();
            if (effectInstance == null || effectInstance.m_19544_() != MobEffects.f_19605_) continue;
            int amplifier = effectInstance.m_19564_();
            int duration = effectInstance.m_19557_();
            healthIncrement += (float)Math.floor(duration / Math.max(50 >> amplifier, 1));
            break;
        }
        cir.setReturnValue((Object)Float.valueOf(healthIncrement));
    }
}

