/*
 * Decompiled with CFR 0.152.
 */
package ru.markthelark.spiceofoverhaul.network;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import ru.markthelark.spiceofoverhaul.network.MessageQueueSync;
import ru.markthelark.spiceofoverhaul.util.FoodHashAccessor;

public class SyncHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("spiceofoverhaul", "sync")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();

    public static void init() {
        CHANNEL.registerMessage(1, MessageQueueSync.class, MessageQueueSync::encode, MessageQueueSync::decode, MessageQueueSync::handle);
        MinecraftForge.EVENT_BUS.register((Object)new SyncHandler());
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer _player = (ServerPlayer)event.getEntity();
        if (!(_player.m_36324_() instanceof FoodHashAccessor)) {
            return;
        }
        MessageQueueSync msg = new MessageQueueSync(((FoodHashAccessor)_player.m_36324_()).getFoodQueueString());
        CHANNEL.sendTo((Object)msg, _player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

