/*
 * Decompiled with CFR 0.152.
 */
package ru.markthelark.spiceofoverhaul.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import ru.markthelark.spiceofoverhaul.Config;
import ru.markthelark.spiceofoverhaul.items.FoodBag;

public class FoodEventHandler {
    static ResourceLocation PLAYER_HEALTH_ELEMENT = new ResourceLocation("minecraft", "player_health");

    @SubscribeEvent
    public static void tickPlayer(LivingEvent.LivingTickEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!player.m_7500_() && !player.m_21224_() && Config.idleExhaustion) {
            player.m_36399_(Config.idleExhaustionQuantity);
        }
        int difficultyScale = Config.strikesDifficultyBase + player.m_9236_().m_46791_().m_19028_() * Config.StrikesDifficultyScale;
        FoodData foodData = player.m_36324_();
        int hunger = foodData.m_38702_();
        float saturation = foodData.m_38722_();
        float healthPercent = player.m_21223_() / player.m_21233_();
        @Nullable MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation("farmersdelight", "nourishment"));
        if (effect != null && player.m_21023_(effect)) {
            return;
        }
        if (hunger <= Config.hungerLevel - 4 && Config.lowHungerStrikes || healthPercent <= Config.healthLevel - 0.2f && Config.lowHealthStrikes || saturation >= Config.saturationLevel + 4.0f && Config.highSaturationStrikes) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 19, difficultyScale, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 19, difficultyScale, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 19, difficultyScale - 2, false, false, false));
            if (Config.strikesNausea) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 79, 0, false, false, false));
            }
        } else if (hunger <= Config.hungerLevel - 3 && Config.lowHungerStrikes || healthPercent <= Config.healthLevel - 0.15f && Config.lowHealthStrikes || saturation >= Config.saturationLevel + 3.0f && Config.highSaturationStrikes) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 19, difficultyScale - 1, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 19, difficultyScale - 1, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 19, difficultyScale - 3, false, false, false));
        } else if (hunger <= Config.hungerLevel - 2 && Config.lowHungerStrikes || healthPercent <= Config.healthLevel - 0.1f && Config.lowHealthStrikes || saturation >= Config.saturationLevel + 2.0f && Config.highSaturationStrikes) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 19, difficultyScale - 2, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 19, difficultyScale - 2, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 19, difficultyScale - 4, false, false, false));
        } else if (hunger <= Config.hungerLevel - 1 && Config.lowHungerStrikes || healthPercent <= Config.healthLevel - 0.05f && Config.lowHealthStrikes || saturation >= Config.saturationLevel + 1.0f && Config.highSaturationStrikes) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 19, difficultyScale - 3, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 19, difficultyScale - 3, false, false, false));
        } else if (hunger <= Config.hungerLevel && Config.lowHungerStrikes || healthPercent <= Config.healthLevel && Config.lowHealthStrikes || saturation >= Config.saturationLevel && Config.highSaturationStrikes) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 19, difficultyScale - 4, false, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 19, difficultyScale - 4, false, false, false));
        }
    }

    @SubscribeEvent
    public static void onFoodStartEating(LivingEntityUseItemEvent.Start event) {
        if (Config.modifyFoodEatingSpeed && (event.getItem().m_41720_().m_41472_() || event.getItem().m_41720_() instanceof FoodBag)) {
            int hunger = event.getItem().getFoodProperties(event.getEntity()).m_38744_();
            event.setDuration(hunger * 6 + 8);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Pre event) {
        if (Config.addGuiText && event.getOverlay() == GuiOverlayManager.findOverlay((ResourceLocation)PLAYER_HEALTH_ELEMENT)) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ForgeGui gui = (ForgeGui)mc.f_91065_;
            int foodIconsOffset = gui.rightHeight;
            int right = mc.m_91268_().m_85445_() / 2;
            int top = mc.m_91268_().m_85446_() - foodIconsOffset;
            if (!player.m_21224_() && !player.m_7500_()) {
                float healthPercent = player.m_21223_() / player.m_21233_();
                if (healthPercent <= 0.15f) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "dying", right - 91 - "dying".length() * 6 + 1, top, -1, false);
                } else if (healthPercent <= 0.3f) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "injured", right - 91 - "injured".length() * 6 + 1, top, -1, false);
                } else if (healthPercent < 0.5f) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "hurt", right - 91 - "hurt".length() * 6 + 1, top, -1, false);
                }
                if (player.m_36324_().m_38702_() <= 6) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "starving", right + 93, top, -1, false);
                } else if (player.m_36324_().m_38702_() <= 10) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "hungry", right + 93, top, -1, false);
                } else if (player.m_36324_().m_38702_() <= 14) {
                    event.getGuiGraphics().m_280056_(gui.m_93082_(), "peckish", right + 93, top, -1, false);
                }
            }
        }
    }
}

